% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{detect_file_enc}
\alias{detect_file_enc}
\title{Files encoding detection}
\usage{
detect_file_enc(x)
}
\arguments{
\item{x}{Character vector, containing file names or paths.}
}
\value{
A character vector of length equal to the length of x and contains
guessed iconv-compatible encodings names.
}
\description{
This function tries to detect character encoding of files.
}
\examples{
# detect ASCII file encoding
detect_file_enc(system.file("DESCRIPTION", package = "uchardet"))

# paths to examples files
ex_path <- system.file("examples", package = "uchardet")
# various langaues and encodings examples files
ex_files <- Sys.glob(file.path(ex_path, "*", "*"))
# detect files encodings
detect_file_enc(head(ex_files, 10))
}
