% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_pc_2D_mdtm.R
\name{pc_2D_mdtm}
\alias{pc_2D_mdtm}
\title{Create a Digital Terrain Model from UAV generated point clouds by minimum altitude sampling (multiple resolutions of sampling gridsize)}
\usage{
pc_2D_mdtm(
  laspcFile = NULL,
  gisdbasePath = NULL,
  grassVersion = 1,
  searchPath = NULL,
  tension = 20,
  sampleMethod = "min",
  cutExtent = NULL,
  sampleGridSize = c(100, 50, 25),
  sw_range = 0.2,
  targetGridSize = 0.1,
  splineThresGridSize = 0.5,
  projFolder = NULL,
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs +ellps=WGS84",
  giLinks = giLinks,
  verbose = FALSE
)
}
\arguments{
\item{laspcFile}{character. default is \code{NULL} path  to the laz/las file(s)}

\item{gisdbasePath}{character. default is \code{NULL} root directory of the project. NOTE the function creates two subfolder named \code{run} and \code{output}}

\item{grassVersion}{numeric. version of GRASS as derived by findGRASS() default is 1 (=oldest/only version) please note GRASS version later than 7.4 is not working with r.inlidar}

\item{searchPath}{path to look for grass}

\item{tension}{numeric. tension of spline interpolation.}

\item{sampleMethod}{character. sampling method of r.in.lidar Statistic to use for raster values Options: n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean Default: mean}

\item{cutExtent}{clip area}

\item{sampleGridSize}{list of integer values for the chooses moving window resolution for optimize Ground model default is c(150,50,5)}

\item{sw_range}{numeric multiplicator for the accepted percentage difference of two search windows height values range typically [0,1] . Example z value of  sampleGridSize[100] - sampleGridSize[50] = 50  =>    50 *0.2 = 10. So 10 meters are acceped as a valid value.}

\item{targetGridSize}{numeric. the resolution of the target DTM raster}

\item{splineThresGridSize}{numeric. threshold of minimum gridsize tha is used for splininterpolation if the desired resolution is finer a two step approximation is choosen
first step spline interpolation using the treshold gridsize second step bilinear resampling to the desired targetGridSize.}

\item{projFolder}{subfolders that will be created/linked for R related GRASS processing}

\item{proj4}{character. valid proj4 string that should be assumingly the correct one}

\item{giLinks}{list of link2GI cli pathes, default is NULL}

\item{verbose}{to be quiet (1)}
}
\value{
Digital Terrain Model from UAV generated point clouds as  raster* object
}
\description{
Create a Digital Terrain Model from a high density point cloud as typically derived by an optical UAV retrieval. Due to the poor estimation of ground points
a minimum samopling approach is applied. It retrieves on analyzing multiple sampling resolutions gridsizes the ground minimum values and interpolates on these samples a surface grid with a higher target
resolution. this is a kind of an try and error process and provides fairly good results if the point cloud shows at least some real surface points on a not to coarse grid.
}
\examples{
\dontrun{

require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-list()
giLinks$grass<-link2GI::linkGRASS7(returnPaths = TRUE)
if (giLinks$grass$exist) {

# get the data
utils::download.file(url="https://github.com/gisma/gismaData/raw/master/uavRst/data/lidar.las",
                     destfile="lasdata.las")

# create 2D point cloud DTM
dtm3 <- pc_2D_mdtm(laspcFile = "lasdata.las",
                   gisdbasePath = tempdir(),
                   tension = 20 ,
                   targetGridSize = 0.5,
                   sampleGridSize = c(100, 50, 25),
                   giLinks = giLinks)
 raster::plot(dtm3)
}
}
}
\author{
Chris Reudenbach, Finn Möller
}
