% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_treepos.R
\name{treepos_RL}
\alias{treepos_RL}
\title{'rLiDAR' based tree detection of a LiDAR-derived Canopy Height Model (CHM)}
\usage{
treepos_RL(chm = NULL, movingWin = 7, minTreeAlt = 2)
}
\arguments{
\item{chm}{Canopy height model in \code{raster} or \code{SpatialGridDataFrame} file format. Should be the same that was used to create
the input for \code{treepos}.}

\item{movingWin}{Size (in pixels) of the moving window to detect local maxima.}

\item{minTreeAlt}{Height threshold (m) below a pixel cannot be a local maximum. Local maxima values are used to define tree tops.}
}
\description{
Detects and computes the location and height of individual trees within
the LiDAR-derived Canopy Height Model (CHM). The algorithm implemented in this function
is local maximum with a fixed window size. Carlos A. Silva et all.: R package \href{https://CRAN.R-project.org/package=rLiDAR}{rLiDAR}\cr
}
\examples{

## required packages
require(uavRst)

## load data
data(chm_seg)

## find trees
tPosRL <- treepos_RL(chm = chm_seg[[1]],
                    movingWin = 3,
                    minTreeAlt = 10)
## visualisation
raster::plot(tPosRL)
}
