% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soloTB.R
\name{soloLog}
\alias{soloLog}
\title{Download, reorganize and export the telemetry (tlog) files from 3DR Solo (and Pixhawk)}
\usage{
soloLog(logFiles = "solo.t*", logDir = "~/soloLog", downloadOnly = FALSE,
  netWarn = TRUE, organize = TRUE, makeSP = FALSE)
}
\arguments{
\item{logFiles}{pattern of which kind of logs should be downloaded for telemetry it is "solo.t*" which means all log files...}

\item{logDir}{(existing) destination path to which the logs should be downloaded to}

\item{downloadOnly}{default = FALSE, set to TRUE  if you ONLY want to download the log files from the solo controller to the logDir}

\item{netWarn}{if true warns and waits before starting a connection to the controller to connect to the solo wifi}

\item{organize}{renames the log and gpx files according to their timeperiod}

\item{makeSP}{generates SP objects from the gpx files}
}
\description{
Wraps the mavtogpx.py converter as provided by the dronkit library. It downloads and/ or converts the 3DR Solo logfiles. Otionally you may import the geometries and data as sp objects in R
}
\note{
for using the solo stuff you need to install: \cr 
sudo pip install pymavlink  \cr 
sudo pip install dronekit-sitl \cr 
sudo pip install dronekit \cr 
sudo apt-get install sshpass \cr 
\cr Additionally you need to be connected to a running 3DR Solo uav
}
\examples{
\dontrun{
## download current telemetry log file from controller and convert it to gpx
soloLog(logDir="~/tmp/solo",logFiles = "solo.tlog")

## download all available telemetry logfiles from the controller
soloLog(logDir="~/tmp/solo")

## download ALL logfiles from the controller
soloLog(logDir="~/tmp/solo", logFiles = "*")
}
}
