% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{Tile-class}
\alias{Tile-class}
\title{Tile}
\value{
An S4 object of class "Tile".
}
\description{
Class to hold the reading of a single tile. It can also store a single tile of a mosaic, to which we will refer to as chunks. It is an extended class for \code{\link[=SpectralInfo-class]{SpectralInfo}}, adding an extra slot to hold the uFTIR Microscope readings -called Spectra. The functions \code{\link{tile_read}} and \code{\link{mosaic_chunk}} return an object of this class. The class has a defined method to plot, which can be called either by the generic \code{\link[graphics]{plot}} or by \code{\link{plot_tile}}. You can use an object of this class in the following functions:
\describe{
    \item{\code{\link{plot_tile}}}{To plot a heat map of the reading. Available too through the generic \code{\link[graphics]{plot}}.}
    \item{\code{\link{tile_base_corr}}}{A preprocessing function that replace negative values with zeros.}
    \item{\code{\link{wavealign}}}{A resampling method that allows to match the wavenumbers of a given tile/chunk with the wavenumbers of a \code{\link[=SpectralReference-class]{SpectralReference}}.}
    \item{\code{\link{tile_sam}}}{When a Tile object is linked to a \code{\link[=SpectralReference-class]{SpectralReference}} by a former call to \code{\link{wavealign}}, this function performs a spectral angle mapper match between the Tile and the SpectralReference.}
    \item{\code{\link{get_profile_tile}}}{To get the pixels spectra that matched a given polymer/cluster.}
}
}
\section{Slots}{

\describe{
\item{\code{Spectra}}{array. The aquired spectra (.dat or dmd file)}
}}

\examples{
NULL
}
