% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sam.r
\name{mask_sam}
\alias{mask_sam}
\title{Mask SAM}
\usage{
mask_sam(x, threshold = 1.1)
}
\arguments{
\item{x}{an array. Tipically, the array at the raw_sam slot of a SAM object.}

\item{threshold}{cut off value above wich, the SAM relation found is deemed unsignificant}
}
\value{
S3 matrix
}
\description{
The spectral angle mapper algorithm always find a match, as it was designed to compare between to spectra. However, somethimes the match is far from good and the user could want to drop the poorly matched pixels. This function will create a mask for such a purpose.
}
\examples{
set.seed(4356)
x <- array(abs(rnorm(1000)), c(10, 10, 10))
x <- mask_sam(x, 0.1)
# trick to plot as clipper
class(x) <- c("clipper", "matrix")
plot(x, legend = FALSE)
}
