% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzupdater.R
\name{install_tz}
\alias{install_tz}
\title{install_tz}
\usage{
install_tz(
  tgt_version = "2019c",
  zic_path = NA,
  target_folder = paste0(tempdir(), "/tzupdater/data/IANA_release"),
  show_zic_log = FALSE,
  err_stop = TRUE,
  activate_tz = TRUE,
  verbose = TRUE,
  fail_if_zic_missing = FALSE
)
}
\arguments{
\item{tgt_version}{Version to download and compile (eg 2019c, 2019a).}

\item{zic_path}{Optional for Windows: path to the zic compiler (if not in C:\\Cygwin\\usr\\sbin)}

\item{target_folder}{Optional target folder. Default will be tzupdater/data/IANA_release as in tempdir()}

\item{show_zic_log}{Optional: show logs from the zic compiler (TRUE/FALSE). Default FALSE.}

\item{err_stop}{Stop on error (TRUE/FALSE). Default TRUE. Recommanded to TRUE.}

\item{activate_tz}{Activate the tz database once installed. Default TRUE.}

\item{verbose}{Print additional information to the console TRUE/FALSE. Default TRUE.}

\item{fail_if_zic_missing}{Stop execution if zic is missing (default FALSE, will only display a message)}
}
\description{
Download and compile a tz database from the IANA website and make it active as an option.
In case the tz db exists already, do not download again.
}
\examples{
# Install tz database 2019c
install_tz("2019c")

}
