% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R, R/documentation.R
\name{print.twosamples}
\alias{print.twosamples}
\alias{summary.twosamples}
\alias{twosamples_class}
\title{twosamples_class}
\usage{
\method{print}{twosamples}(x, ...)

\method{summary}{twosamples}(object, alpha = 0.05, ...)
}
\arguments{
\item{x}{twosamples object}

\item{...}{other parameters to be passed to print or summary functions}

\item{object}{twosamples-object to summarize}

\item{alpha}{Significance threshold for determining null rejection}
}
\value{
\itemize{
\item \code{print.twosamples()} returns nothing
\item \code{summarize.twosamples()} returns nothing
}
}
\description{
Objects of Class twosamples are output by all of the \verb{*_test} functions in the \code{twosamples} package.
}
\details{
By default they consist of:a length 2 vector, the first item being the test statistic, the second the p-value.
That vector has the following attributes:
\enumerate{
\item details: length 3 vector with the sample sizes for each sample and the number of bootstraps
\item test_type: a string describing the type of the test statistic
}

It may also have two more attributes, depending on options used when running the \verb{*_test} function. These are useful for plotting and combining test runs.
\enumerate{
\item bootstraps: a vector containing all the bootstrapped null values
\item samples: a list containing both the samples that were tested
}

and by virtue of being a named length 2 vector of class "twosamples" it has the following two attributes:
\enumerate{
\item names: c("Test Stat","P-Value")
\item class: "twosamples"
}

Multiple Twosamples objects made by the same \verb{*_test} routine being run on the same data can be combined (getting correct p-value and correct attributes) with the function \code{combine_twosamples()}.
}
\section{Functions}{
\itemize{
\item \code{print.twosamples}: Print method for objects of class twosamples

\item \code{summary.twosamples}: Summary method for objects of class twosamples
}}

\seealso{
\code{\link[=plot.twosamples]{plot.twosamples()}}, \code{\link[=combine.twosamples]{combine.twosamples()}}
}
