#' Information for the results of the general election in Turkey in 1995.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 1995 general election in Turkey.
#'
#' @format A data frame with 13 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_Baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_1995_turkiye"

#' Information for the results of the general election in Turkey in 1999.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 1999 general election in Turkey.
#'
#' @format A data frame with 21 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_Baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_1999_turkiye"



#' Information for the results of the general election in Turkey in 2002.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 2002 general election in Turkey.
#'
#' @format A data frame with 19 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_Baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2002_turkiye"



#' Information for the results of the general election in Turkey in 2007.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 2007 general election in Turkey.
#'
#' @format A data frame with 15 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_Baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2007_turkiye"


#' Information for the results of the general election in Turkey in 2011.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 2011 general election in Turkey.
#'
#' @format A data frame with 16 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_baskani}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2011_turkiye"



#' Information for the results of the general election in Turkey in June 2015.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in June 2015 general election in Turkey.
#'
#' @format A data frame with 21 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_haziran_2015_turkiye"



#' Information for the results of the general election in Turkey in November 2015.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in November 2015 general election in Turkey.
#'
#' @format A data frame with 17 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_kasim_2015_turkiye"



#' Information for the results of the general election in Turkey in 2018.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 2018 general election in Turkey.
#'
#' @format A data frame with 9 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_baskan}{parti baskani adi, name of the head of the party}
#'   \item{Toplam}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2018_turkiye"



#' Information for the results of the general election in Turkey in 2023.
#'
#' A dataset showing the information for party competing in the election, head of party, vote in count and percentage and the number of seats obtained in the council after the election region in 2023 general election in Turkey.
#'
#' @format A data frame with 25 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti adi, name of the political party}
#'   \item{Genel_baskan}{parti baskani adi, name of the head of the party}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#'   \item{Sandalye}{secim sonucu kazanilan sandalye sayisi, the number of seats obtained in the council after the election}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2023_turkiye"


#' Information for the results of the presidental election in Turkey in 2014.
#'
#' A dataset showing the information for the candidates competing in the presidental election, and their votes in count and percentage.
#'
#' @format A data frame with 3 rows and 3 variables:
#' \describe{
#'   \item{Aday}{aday adi, name of the candidate}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2014_turkiye"

#' Information for the results of the presidental election in Turkey in 2018.
#'
#' A dataset showing the information for the candidates competing in the presidental election, and their votes in count and percentage.
#'
#' @format A data frame with 6 rows and 3 variables:
#' \describe{
#'   \item{Aday}{aday adi, name of the candidate}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2018_turkiye"


#' Information for the results of the presidental election in Turkey in the first round in 2023.
#'
#' A dataset showing the information for the candidates competing in the presidental election, and their votes in count and percentage.
#'
#' @format A data frame with 4 rows and 3 variables:
#' \describe{
#'   \item{Aday}{aday adi, name of the candidate}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2023_ilk_tur_turkiye"


#' Information for the results of the presidental election in Turkey in the second round in 2023.
#'
#' A dataset showing the information for the candidates competing in the presidental election, and their votes in count and percentage.
#'
#' @format A data frame with 4 rows and 3 variables:
#' \describe{
#'   \item{Aday}{aday adi, name of the candidate}
#'   \item{Oy}{alinan oy sayisi, the number of votes received}
#'   \item{Yuzde}{alinan oy sayisi (yuzde olarak), the percentage of votes received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2023_ikinci_tur_turkiye"

#' Information for the results of the presidential election in Turkey by province in 2014
#'
#' A dataset showing the information for the candidates competing in the presidential election, and their votes in count and percentage.
#'
#' @format  data frame with 81 rows and 10 variables
#'   \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of voters}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who vote}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy sayisi, the number of valid votes}
#'   \item{RECEP_TAYYIP_ERDOGAN}{recep tayyip erdoganin aldigi oy sayisi, the number of valid votes that recep tayyip erdogan received}
#'   \item{SELAHATTIN_DEMIRTAS}{selahattin demirtasin aldigi oy sayisi, the number of valid votes that selahattin demirtas received}
#'   \item{EKMELEDDIN_MEHMET_IHSANOGLU}{ekmeleddin mehmet ihsanoglunun aldigi oy sayisi, the number of valid votes that ekmeleddin mehmet ihsanoglu received}
#'   \item{RECEP_TAYYIP_ERDOGAN_\%}{recep tayyip erdoganin aldigi oy yuzdesi, the percentage of valid votes that recep tayyip erdogan received}
#'   \item{SELAHATTIN_DEMIRTAS_\%}{selahattin demirtasin aldigi oy yuzdesi, the percentage of valid votes that selahattin demirtas received}
#'   \item{EKMELEDDIN_MEHMET_IHSANOGLU_\%}{ekmeleddin mehmet ihsanoglunun aldigi oy yuzdesi, the percentage of valid votes that ekmeleddin mehmet ihsanoglu received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2014_il"


#' Information for the results of the presidental election in Turkey by province in 2018
#'
#' A dataset showing the information for the candidates competing in the presidental election, and their votes in count and percentage.
#'
#' @format A data frame with 81 rows and 105 variables:
#' \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of voters}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who vote}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy sayisi, the number of valid votes }
#'   \item{MUHARREM_INCE}{muharrem incenin aldigi oy sayisi, the number of valid votes that muharrem ince received }
#'   \item{MERAL_AKSENER}{meral aksenerin aldigi oy sayisi, the number of valid votes that meral aksener received }
#'   \item{RECEP_TAYYIP_ERDOGAN}{recep tayyip erdoganin aldigi oy sayisi, the number of valid votes that recep tayyip erdogan received }
#'   \item{SELAHATTIN_DEMIRTAS}{selahattin demirtasin aldigi oy sayisi, the number of valid votes that selahattin demirtas received}
#'   \item{TEMEL_KARAMOLLAOGLU}{temel karamollaoglunun aldigi oy sayisi, the number of valid votes that temel karamollaoglu received }
#'   \item{DOGU_PERINCEK}{dogu perincekin aldigi oy sayisi, the number of valid votes that dogu perincek received }
#'   \item{MUHARREM_INCE_\%}{muharrem incenin aldigi oy yuzdesi, the percentage of valid votes that muharrem ince received }
#'   \item{MERAL_AKSENER_\%}{meral aksenerin aldigi oy yuzdesi, the percentage of valid votes that meral aksener received }
#'   \item{RECEP_TAYYIP_ERDOGAN_\%}{recep tayyip erdoganin aldigi oy yuzdesi, the percentage of valid votes that recep tayyip erdogan received }
#'   \item{SELAHATTIN_DEMIRTAS_\%}{selahattin demirtasin aldigi oy yuzdesi, the percentage of valid votes that selahattin demirtas received}
#'   \item{TEMEL_KARAMOLLAOGLU_\%}{temel karamollaoglunun aldigi oy yuzdesi, the percentage of valid votes that temel karamollaoglu received }
#'   \item{DOGU_PERINCEK_\%}{dogu perincekin aldigi oy yuzdesi, the percentage of valid votes that dogu perincek received }
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2018_il"


#' Information for the results of the second round of the presidential election in Turkey by province in 2023
#'
#' A dataset showing the information for the candidates competing in the second round of the presidential election, and their votes in count and percentage.
#'
#' @format A data frame with 81 rows and 8 variables:
#'  \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who vote}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes}
#'   \item{RECEP_TAYYIP_ERDOGAN}{recep tayyip erdoganin aldigi oy sayisi, the number of valid votes that Recep Tayyip Erdogan received}
#'   \item{KEMAL_KILICDAROGLU}{kemal kilicdaroglunun aldigi oy sayisi, the number of valid votes that Kemal Kilicdaroglu received}
#'   \item{RECEP_TAYYIP_ERDOGAN_\%}{recep tayyip erdoganin aldigi oy yuzdesi, the percentage of valid votes that Recep Tayyip Erdogan received}
#'   \item{KEMAL_KILICDAROGLU_\%}{kemal kilicdaroglunun aldigi oy yuzdesi, the percentage of valid votes that Kemal Kilicdaroglu received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2023_ikinci_tur_il"

#' Information for the results of the first round of the presidential election in Turkey by province in 2023
#'
#' A dataset showing the information for the candidates competing in the first round of the presidential election, and their votes in count and percentage.
#'
#' @format A data frame with 81 rows and 12 variables:
#'  \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who vote}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes}
#'   \item{RECEP_TAYYIP_ERDOGAN}{recep tayyip erdoganin aldigi oy sayisi, the number of valid votes that Recep Tayyip Erdogan received}
#'   \item{MUHARREM_INCE}{muharrem incenin aldigi oy sayisi, the number of valid votes that Muharrem Ince received}
#'   \item{KEMAL_KILICDAROGLU}{kemal kilicdaroglunun aldigi oy sayisi, the number of valid votes that Kemal Kilicdaroglu received}
#'   \item{SINAN_OGAN}{sinan oganin aldigi oy sayisi, the number of valid votes that Sinan Ogan received}
#'   \item{RECEP_TAYYIP_ERDOGAN_\%}{recep tayyip erdoganin aldigi oy yuzdesi, the percentage of valid votes that Recep Tayyip Erdogan received}
#'   \item{MUHARREM_INCE_\%}{muharrem incenin aldigi oy yuzdesi, the percentage of valid votes that Muharrem Ince received}
#'   \item{KEMAL_KILICDAROGLU_\%}{kemal kilicdaroglunun aldigi oy yuzdesi, the percentage of valid votes that Kemal Kilicdaroglu received}
#'   \item{SINAN_OGAN_\%}{sinan oganin aldigi oy yuzdesi, the percentage of valid votes that Sinan Ogan received}
#' }
#' @source {YSK (Supreme Election Council)}
"cb_2023_ilk_tur_il"

#' Information for the results of the general election in Turkey by province in 1995
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 15 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{RP}{rp oy sayisi, the number of votes that the Welfare Party (RP) received}
#'   \item{RP_\%}{rp oy yuzdesi, the percentage of votes that the Welfare Party (RP) received}
#'   \item{ANAP}{anap oy sayisi, the number of votes that the Motherland Party (ANAP) received}
#'   \item{ANAP_\%}{anap oy yuzdesi, the percentage of votes that the Motherland Party (ANAP) received}
#'   \item{DYP}{dyp oy sayisi, the number of votes that the True Path Party (DYP) received}
#'   \item{DYP_\%}{dyp oy yuzdesi, the percentage of votes that the True Path Party (DYP) received}
#'   \item{DSP}{dsp oy sayisi, the number of votes that the Democratic Left Party (DSP) received}
#'   \item{DSP_\%}{dsp oy yuzdesi, the percentage of votes that the Democratic Left Party (DSP) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_1995_il"

#' Information for the results of the general election in Turkey by province in 1999
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 15 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{DSP}{dsp oy sayisi, the number of votes that the Democratic Left Party (DSP) received}
#'   \item{DSP_\%}{dsp oy yuzdesi, the percentage of votes that the Democratic Left Party (DSP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{FP}{fp oy sayisi, the number of votes that the Virtue Party (FP) received}
#'   \item{FP_\%}{fp oy yuzdesi, the percentage of votes that the Virtue Party (FP) received}
#'   \item{ANAP}{anap oy sayisi, the number of votes that the Motherland Party (ANAP) received}
#'   \item{ANAP_\%}{anap oy yuzdesi, the percentage of votes that the Motherland Party (ANAP) received}
#'   \item{DYP}{dyp oy sayisi, the number of votes that the True Path Party (DYP) received}
#'   \item{DYP_\%}{dyp oy yuzdesi, the percentage of votes that the True Path Party (DYP) received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_1999_il"


#' Information for the results of the general election in Turkey by province in 2002
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 15 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{DYP}{dyp oy sayisi, the number of votes that the True Path Party (DYP) received}
#'   \item{DYP_\%}{dyp oy yuzdesi, the percentage of votes that the True Path Party (DYP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{GP}{gp oy sayisi, the number of votes that the Young Party (GP) received}
#'   \item{GP_\%}{gp oy yuzdesi, the percentage of votes that the Young Party (GP) received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2002_il"

#' Information for the results of the general election in Turkey by province in 2007
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 13 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{DP}{dp oy sayisi, the number of votes that the Democratic Party (DP) received}
#'   \item{DP_\%}{dp oy yuzdesi, the percentage of votes that the Democratic Party (DP) received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2007_il"

#' Information for the results of the general election in Turkey by province in 2011
#'
#' A dataset showing the information for the political parties and independent candidates competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 13 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{Bagimsiz}{bagimsiz adaylarin oy sayisi, the number of votes that independent candidates received}
#'   \item{Bagimsiz_\%}{bagimsiz adaylarin oy yuzdesi, the percentage of votes that independent candidates received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2011_il"

#' Information for the results of the general election in Turkey by province in 2018
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 12 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{HDP}{hdp oy sayisi, the number of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{HDP_\%}{hdp oy yuzdesi, the percentage of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{IYI_Parti}{iyi parti oy sayisi, the number of votes that the Good Party (IYI Parti) received}
#'   \item{IYI_Parti_\%}{iyi parti oy yuzdesi, the percentage of votes that the Good Party (IYI Parti) received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2018_il"

#' Information for the results of the general election in Turkey by province in 2023
#'
#' A dataset showing the information for each political party and alliance competing in the general election, their individual vote counts, percentages, and the overall voter statistics by province.
#'
#' @format A data frame with 81 rows and 63 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who vote}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes}
#'   \item{MILLET}{millet partisinin oy sayisi, the number of votes the Nation Party received}
#'   \item{HAK-PAR}{hak-par'in oy sayisi, the number of votes the Rights and Freedoms Party received}
#'   \item{TKP}{tkp'nin oy sayisi, the number of votes the Communist Party of Turkey received}
#'   \item{TKH}{tkh'nin oy sayisi, the number of votes the People's Liberation Party received}
#'   \item{SOL_PARTI}{sol parti'nin oy sayisi, the number of votes the Left Party received}
#'   \item{GENCPARTI}{gencparti'nin oy sayisi, the number of votes the Young Party received}
#'   \item{MEMLEKET}{memleket partisinin oy sayisi, the number of votes the Homeland Party received}
#'   \item{BBP}{bbp'nin oy sayisi, the number of votes the Great Unity Party received}
#'   \item{AK_Parti}{ak parti'nin oy sayisi, the number of votes the Justice and Development Party received}
#'   \item{YENIDEN_REFAH}{yeniden refah partisinin oy sayisi, the number of votes the Refah Party received}
#'   \item{MHP}{mhp'nin oy sayisi, the number of votes the Nationalist Movement Party received}
#'   \item{YESIL_SOL_PARTI}{yesil sol partinin oy sayisi, the number of votes the Green Left Party received}
#'   \item{TIP}{tip'in oy sayisi, the number of votes the Labour Party received}
#'   \item{AB}{ab'nin oy sayisi, the number of votes the Bloc Party received}
#'   \item{ANAP}{anap'in oy sayisi, the number of votes the Motherland Party received}
#'   \item{YP}{yp'nin oy sayisi, the number of votes the New Path Party received}
#'   \item{HKP}{hkp'nin oy sayisi, the number of votes the People's Liberation Party received}
#'   \item{MILLI_YOL}{milli yol'un oy sayisi, the number of votes the National Course Party received}
#'   \item{VATAN_PARTISI}{vatan partisinin oy sayisi, the number of votes the Homeland Party received}
#'   \item{GBP}{gbp'nin oy sayisi, the number of votes the Independent Turkey Party received}
#'   \item{CHP}{chp'nin oy sayisi, the number of votes the Republican People's Party received}
#'   \item{IYI_Parti}{iyi parti'nin oy sayisi, the number of votes the Good Party received}
#'   \item{AP}{ap'nin oy sayisi, the number of votes the Alternative Party received}
#'   \item{ZAFER_PARTISI}{zafer partisinin oy sayisi, the number of votes the Victory Party received}
#'   \item{SOSYALIST_GUC_BIRLIGI_ITTIFAKI}{sosyalist guc birligi ittifakinin oy sayisi, the number of votes the Socialist Power Union Alliance received}
#'   \item{CUMHUR_ITTIFAKI}{cumhur ittifakinin oy sayisi, the number of votes the People's Alliance received}
#'   \item{EMEK_VE_OZGURLUK_ITTIFAKI}{emek ve ozgurluk ittifakinin oy sayisi, the number of votes the Labour and Freedom Alliance received}
#'   \item{MILLET_ITTIFAKI}{millet ittifakinin oy sayisi, the number of votes the Nation Alliance received}
#'   \item{ATA_ITTIFAKI}{ata ittifakinin oy sayisi, the number of votes the Ancestor Alliance received}
#'   \item{BAGIMSIZ_TOPLAM_OY}{bagimsiz adaylarin toplam oy sayisi, the total number of votes independent candidates received}
#'   \item{MILLET_\%}{millet partisinin oy yuzdesi, the percentage of votes the Nation Party received}
#'   \item{HAK-PAR_\%}{hak-par'in oy yuzdesi, the percentage of votes the Rights and Freedoms Party received}
#'   \item{TKP_\%}{tkp'nin oy yuzdesi, the percentage of votes the Communist Party of Turkey received}
#'   \item{TKH_\%}{tkh'nin oy yuzdesi, the percentage of votes the People's Liberation Party received}
#'   \item{SOL_PARTI_\%}{sol parti'nin oy yuzdesi, the percentage of votes the Left Party received}
#'   \item{GENCPARTI_\%}{gencparti'nin oy yuzdesi, the percentage of votes the Young Party received}
#'   \item{MEMLEKET_\%}{memleket partisinin oy yuzdesi, the percentage of votes the Homeland Party received}
#'   \item{BBP_\%}{bbp'nin oy yuzdesi, the percentage of votes the Great Unity Party received}
#'   \item{AK_Parti_\%}{ak parti'nin oy yuzdesi, the percentage of votes the Justice and Development Party received}
#'   \item{YENIDEN_REFAH_\%}{yeniden refah partisinin oy yuzdesi, the percentage of votes the Refah Party received}
#'   \item{MHP_\%}{mhp'nin oy yuzdesi, the percentage of votes the Nationalist Movement Party received}
#'   \item{YESIL_SOL_PARTI_\%}{yesil sol partinin oy yuzdesi, the percentage of votes the Green Left Party received}
#'   \item{TIP_\%}{tip'in oy yuzdesi, the percentage of votes the Labour Party received}
#'   \item{AB_\%}{ab'nin oy yuzdesi, the percentage of votes the Bloc Party received}
#'   \item{ANAP_\%}{anap'in oy yuzdesi, the percentage of votes the Motherland Party received}
#'   \item{YP_\%}{yp'nin oy yuzdesi, the percentage of votes the New Path Party received}
#'   \item{HKP_\%}{hkp'nin oy yuzdesi, the percentage of votes the People's Liberation Party received}
#'   \item{MILLI_YOL_\%}{milli yol'un oy yuzdesi, the percentage of votes the National Course Party received}
#'   \item{VATAN_PARTISI_\%}{vatan partisinin oy yuzdesi, the percentage of votes the Homeland Party received}
#'   \item{GBP_\%}{gbp'nin oy yuzdesi, the percentage of votes the Independent Turkey Party received}
#'   \item{CHP_\%}{chp'nin oy yuzdesi, the percentage of votes the Republican People's Party received}
#'   \item{IYI_Parti_\%}{iyi parti'nin oy yuzdesi, the percentage of votes the Good Party received}
#'   \item{AP_\%}{ap'nin oy yuzdesi, the percentage of votes the Alternative Party received}
#'   \item{ZAFER_PARTISI_\%}{zafer partisinin oy yuzdesi, the percentage of votes the Victory Party received}
#'   \item{SOSYALIST_GUC_BIRLIGI_ITTIFAKI_\%}{sosyalist guc birligi ittifakinin oy yuzdesi, the percentage of votes the Socialist Power Union Alliance received}
#'   \item{CUMHUR_ITTIFAKI_\%}{cumhur ittifakinin oy yuzdesi, the percentage of votes the People's Alliance received}
#'   \item{EMEK_VE_OZGURLUK_ITTIFAKI_\%}{emek ve ozgurluk ittifakinin oy yuzdesi, the percentage of votes the Labour and Freedom Alliance received}
#'   \item{MILLET_ITTIFAKI_\%}{millet ittifakinin oy yuzdesi, the percentage of votes the Nation Alliance received}
#'   \item{ATA_ITTIFAKI_\%}{ata ittifakinin oy yuzdesi, the percentage of votes the Ancestor Alliance received}
#'   \item{BAGIMSIZ_TOPLAM_OY_\%}{bagimsiz adaylarin toplam oy yuzdesi, the percentage of votes independent candidates received}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_2023_il"


#' Information for the results of the general election in Turkey by province in June 2015
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 82 rows and 13 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{HDP}{hdp oy sayisi, the number of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{HDP_\%}{hdp oy yuzdesi, the percentage of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{Diger}{diger parti oy sayisi, the number of votes that other parties received}
#'   \item{Diger_\%}{diger parti oy yuzdesi, the percentage of votes that other parties received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_haziran_2015_il"

#' Information for the results of the general election in Turkey by province in November 2015
#'
#' A dataset showing the information for the political parties competing in the general election, their vote counts, percentages, and the number of parliamentary seats by province.
#'
#' @format A data frame with 81 rows and 11 variables:
#' \describe{
#'   \item{Il}{il, the name of the province}
#'   \item{MV}{mv, the number of parliamentary seats in each province}
#'   \item{AK_Parti}{ak parti oy sayisi, the number of votes that the Justice and Development Party (AK Parti) received}
#'   \item{AK_Parti_\%}{ak parti oy yuzdesi, the percentage of votes that the Justice and Development Party (AK Parti) received}
#'   \item{CHP}{chp oy sayisi, the number of votes that the Republican People's Party (CHP) received}
#'   \item{CHP_\%}{chp oy yuzdesi, the percentage of votes that the Republican People's Party (CHP) received}
#'   \item{MHP}{mhp oy sayisi, the number of votes that the Nationalist Movement Party (MHP) received}
#'   \item{MHP_\%}{mhp oy yuzdesi, the percentage of votes that the Nationalist Movement Party (MHP) received}
#'   \item{HDP}{hdp oy sayisi, the number of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{HDP_\%}{hdp oy yuzdesi, the percentage of votes that the Peoples' Democratic Party (HDP) received}
#'   \item{Toplam}{toplam oy sayisi, the total number of votes cast in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"genel_secim_kasim_2015_il"


#' Information for the results of the local elections in Turkey in 2004
#'
#' A dataset showing the information for the political parties competing in the local elections, their vote counts, percentages, and the number of municipality and metropolitan municipality mayoral positions won.
#'
#' @format A data frame with 21 rows and 6 variables:
#' \describe{
#'   \item{Parti}{parti, the name of the political party}
#'   \item{Genel_baskani}{genel baskani, the name of the party's leader}
#'   \item{Oy}{oy, the number of votes received by the party}
#'   \item{Yuzde}{yuzde, the percentage of votes received by the party}
#'   \item{Belediye_Baskanligi_Sayisi}{belediye baskanligi sayisi, the number of municipality mayor positions won by the party}
#'   \item{B.Belediye_Baskanligi_Sayisi}{buyuksehir belediye baskanligi sayisi, the number of metropolitan municipality mayor positions won by the party}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2004_buyuksehir_turkiye"

#' Information for the results of the local elections in Turkey in 2009
#'
#' A dataset showing the information for political parties competing in the local elections, their total votes, vote percentages, and the number of mayoral positions won.
#'
#' @format A data frame with 20 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti, the name of the political party}
#'   \item{Genel_baskani}{genel baskani, the general chairperson of the political party}
#'   \item{Oy}{oy, the total number of votes received by the party}
#'   \item{Yuzde}{yuzde, the percentage of votes received by the party}
#'   \item{Belediye_Baskanligi_Sayisi}{belediye baskanligi sayisi, the number of mayoral positions won by the party}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2009_belediye_turkiye"

#' Information for the results of the metropolitan municipality mayoral elections in Turkey in 2009
#'
#' A dataset showing the information for political parties competing in the metropolitan municipality mayoral elections, their total votes, vote percentages, and the number of metropolitan mayoral positions won.
#'
#' @format A data frame with 21 rows and 5 variables:
#' \describe{
#'   \item{Parti}{parti, the name of the political party}
#'   \item{Genel_baskani}{genel baskani, the general chairperson of the political party}
#'   \item{Oy}{oy, the total number of votes received by the party for metropolitan municipality mayoral positions}
#'   \item{Yuzde}{yuzde, the percentage of votes received by the party for metropolitan municipality mayoral positions}
#'   \item{B.Belediye_Baskanligi_Sayisi}{buyuksehir belediye baskanligi sayisi, the number of metropolitan mayoral positions won by the party}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2009_buyuksehir_turkiye"

#' Information for the results of the local elections in Turkey by province in 2009, detailing votes for each party
#'
#' A dataset showing detailed information for each political party competing in the local elections in every province, including vote counts, percentages, and overall voting statistics.
#'
#' @format A data frame with rows for each province and 44 variables:
#' \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters in each province}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who voted in each province}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes in each province}
#'   \item{ANAVATAN}{anavatan partisinin oy sayisi, the number of votes received by the ANAVATAN party in each province}
#'   \item{MHP}{mhp'nin oy sayisi, the number of votes received by the Nationalist Movement Party (MHP) in each province}
#'   \item{LDP}{ldp'nin oy sayisi, the number of votes received by the Liberal Democratic Party (LDP) in each province}
#'   \item{DSP}{dsp'nin oy sayisi, the number of votes received by the Democratic Left Party (DSP) in each province}
#'   \item{DTP}{dtp'nin oy sayisi, the number of votes received by the Democratic Society Party (DTP) in each province}
#'   \item{IP}{ip'nin oy sayisi, the number of votes received by the Independent Turkey Party (IP) in each province}
#'   \item{CHP}{chp'nin oy sayisi, the number of votes received by the Republican People's Party (CHP) in each province}
#'   \item{HAK-PAR}{hak-par'in oy sayisi, the number of votes received by the Rights and Freedoms Party (HAK-PAR) in each province}
#'   \item{BBP}{bbp'nin oy sayisi, the number of votes received by the Great Unity Party (BBP) in each province}
#'   \item{BDP}{bdp'nin oy sayisi, the number of votes received by the Peace and Democracy Party (BDP) in each province}
#'   \item{MILLET}{millet partisinin oy sayisi, the number of votes received by the Nation Party (MILLET) in each province}
#'   \item{ODP}{odp'nin oy sayisi, the number of votes received by the Freedom and Solidarity Party (ODP) in each province}
#'   \item{TKP}{tkp'nin oy sayisi, the number of votes received by the Communist Party of Turkey (TKP) in each province}
#'   \item{DP}{dp'nin oy sayisi, the number of votes received by the Democratic Party (DP) in each province}
#'   \item{SAADET}{saadet partisinin oy sayisi, the number of votes received by the Felicity Party (SAADET) in each province}
#'   \item{AK_PARTI}{ak parti'nin oy sayisi, the number of votes received by the Justice and Development Party (AK PARTI) in each province}
#'   \item{BTP}{btp'nin oy sayisi, the number of votes received by the Independent Turkey Party (BTP) in each province}
#'   \item{EMEP}{emep'in oy sayisi, the number of votes received by the Labour Party (EMEP) in each province}
#'   \item{HYP}{hyp'nin oy sayisi, the number of votes received by the People's Ascent Party (HYP) in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY}{bagimsiz adaylarin toplam oy sayisi, the total number of votes received by independent candidates in each province}
#'   \item{ANAVATAN_\%}{anavatan partisinin oy yuzdesi, the percentage of votes received by the ANAVATAN party in each province}
#'   \item{MHP_\%}{mhp'nin oy yuzdesi, the percentage of votes received by the Nationalist Movement Party (MHP) in each province}
#'   \item{LDP_\%}{ldp'nin oy yuzdesi, the percentage of votes received by the Liberal Democratic Party (LDP) in each province}
#'   \item{DSP_\%}{dsp'nin oy yuzdesi, the percentage of votes received by the Democratic Left Party (DSP) in each province}
#'   \item{DTP_\%}{dtp'nin oy yuzdesi, the percentage of votes received by the Democratic Society Party (DTP) in each province}
#'   \item{IP_\%}{ip'nin oy yuzdesi, the percentage of votes received by the Independent Turkey Party (IP) in each province}
#'   \item{CHP_\%}{chp'nin oy yuzdesi, the percentage of votes received by the Republican People's Party (CHP) in each province}
#'   \item{HAK-PAR_\%}{hak-par'in oy yuzdesi, the percentage of votes received by the Rights and Freedoms Party (HAK-PAR) in each province}
#'   \item{BBP_\%}{bbp'nin oy yuzdesi, the percentage of votes received by the Great Unity Party (BBP) in each province}
#'   \item{BDP_\%}{bdp'nin oy yuzdesi, the percentage of votes received by the Peace and Democracy Party (BDP) in each province}
#'   \item{MILLET_\%}{millet partisinin oy yuzdesi, the percentage of votes received by the Nation Party (MILLET) in each province}
#'   \item{ODP_\%}{odp'nin oy yuzdesi, the percentage of votes received by the Freedom and Solidarity Party (ODP) in each province}
#'   \item{TKP_\%}{tkp'nin oy yuzdesi, the percentage of votes received by the Communist Party of Turkey (TKP) in each province}
#'   \item{DP_\%}{dp'nin oy yuzdesi, the percentage of votes received by the Democratic Party (DP) in each province}
#'   \item{SAADET_\%}{saadet partisinin oy yuzdesi, the percentage of votes received by the Felicity Party (SAADET) in each province}
#'   \item{AK_PARTI_\%}{ak parti'nin oy yuzdesi, the percentage of votes received by the Justice and Development Party (AK PARTI) in each province}
#'   \item{BTP_\%}{btp'nin oy yuzdesi, the percentage of votes received by the Independent Turkey Party (BTP) in each province}
#'   \item{EMEP_\%}{emep'in oy yuzdesi, the percentage of votes received by the Labour Party (EMEP) in each province}
#'   \item{HYP_\%}{hyp'nin oy yuzdesi, the percentage of votes received by the People's Ascent Party (HYP) in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY_\%}{bagimsiz adaylarin toplam oy yuzdesi, the total percentage of votes received by independent candidates in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2009_il"

#' Information for the results of the local elections in Turkey in 2014, focusing on municipal and metropolitan mayoral positions
#'
#' A dataset showing the information for political parties competing in the local elections, their total votes, vote percentages, and the number of municipal and metropolitan mayoral positions won.
#'
#' @format A data frame with rows for each political party and 6 variables:
#' \describe{
#'   \item{Parti}{parti, the name of the political party}
#'   \item{Genel_baskan(lar)}{genel baskan(lar), the general chairperson(s) of the political party}
#'   \item{Oy}{oy, the total number of votes received by the party}
#'   \item{Yuzde}{yuzde, the percentage of votes received by the party}
#'   \item{B.Belediye_Baskanligi_Sayisi}{buyuksehir belediye baskanligi sayisi, the number of metropolitan mayoral positions won by the party}
#'   \item{Belediye_Baskanligi_Sayisi}{belediye baskanligi sayisi, the number of municipal mayoral positions won by the party}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2014_buyuksehir_turkiye"


#' Information for the results of the local elections in Turkey by province in 2014, detailing votes for each party, including percentages
#'
#' A dataset showing detailed information for each political party competing in the local elections in every province, including vote counts, vote percentages, and overall voting statistics.
#'
#' @format A data frame with rows for 81 rows and 52 variables:
#' \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters in each province}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who voted in each province}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes in each province}
#'   \item{HUDA_PAR}{huda-par'in oy sayisi, the number of votes the Free Cause Party (HUDA-PAR) received in each province}
#'   \item{HUDA_PAR_\%}{huda-par'in oy yuzdesi, the percentage of votes the Free Cause Party (HUDA-PAR) received in each province}
#'   \item{DSP}{dsp'nin oy sayisi, the number of votes the Democratic Left Party (DSP) received in each province}
#'   \item{DSP_\%}{dsp'nin oy yuzdesi, the percentage of votes the Democratic Left Party (DSP) received in each province}
#'   \item{DYP}{dyp'nin oy sayisi, the number of votes the True Path Party (DYP) received in each province}
#'   \item{DYP_\%}{dyp'nin oy yuzdesi, the percentage of votes the True Path Party (DYP) received in each province}
#'   \item{TURK_PARTI}{turk partisi'nin oy sayisi, the number of votes the Turkish Party received in each province}
#'   \item{TURK_PARTI_\%}{turk partisi'nin oy yuzdesi, the percentage of votes the Turkish Party received in each province}
#'   \item{HKP}{hkp'nin oy sayisi, the number of votes the People's Liberation Party (HKP) received in each province}
#'   \item{HKP_\%}{hkp'nin oy yuzdesi, the percentage of votes the People's Liberation Party (HKP) received in each province}
#'   \item{TKP}{tkp'nin oy sayisi, the number of votes the Communist Party of Turkey (TKP) received in each province}
#'   \item{TKP_\%}{tkp'nin oy yuzdesi, the percentage of votes the Communist Party of Turkey (TKP) received in each province}
#'   \item{BBP}{bbp'nin oy sayisi, the number of votes the Great Unity Party (BBP) received in each province}
#'   \item{BBP_\%}{bbp'nin oy yuzdesi, the percentage of votes the Great Unity Party (BBP) received in each province}
#'   \item{AK_PARTI}{ak parti'nin oy sayisi, the number of votes the Justice and Development Party (AK PARTI) received in each province}
#'   \item{AK_PARTI_\%}{ak parti'nin oy yuzdesi, the percentage of votes the Justice and Development Party (AK PARTI) received in each province}
#'   \item{YURT-P}{yurt-p'nin oy sayisi, the number of votes the Homeland Party (YURT-P) received in each province}
#'   \item{YURT-P_\%}{yurt-p'nin oy yuzdesi, the percentage of votes the Homeland Party (YURT-P) received in each province}
#'   \item{DP}{dp'nin oy sayisi, the number of votes the Democratic Party (DP) received in each province}
#'   \item{DP_\%}{dp'nin oy yuzdesi, the percentage of votes the Democratic Party (DP) received in each province}
#'   \item{EMEP}{emep'in oy sayisi, the number of votes the Labour Party (EMEP) received in each province}
#'   \item{EMEP_\%}{emep'in oy yuzdesi, the percentage of votes the Labour Party (EMEP) received in each province}
#'   \item{ODP}{odp'nin oy sayisi, the number of votes the Freedom and Solidarity Party (ODP) received in each province}
#'   \item{ODP_\%}{odp'nin oy yuzdesi, the percentage of votes the Freedom and Solidarity Party (ODP) received in each province}
#'   \item{MILLET}{millet partisinin oy sayisi, the number of votes the Nation Party (MILLET) received in each province}
#'   \item{MILLET_\%}{millet partisinin oy yuzdesi, the percentage of votes the Nation Party (MILLET) received in each province}
#'   \item{SAADET}{saadet partisinin oy sayisi, the number of votes the Felicity Party (SAADET) received in each province}
#'   \item{SAADET_\%}{saadet partisinin oy yuzdesi, the percentage of votes the Felicity Party (SAADET) received in each province}
#'   \item{HAK-PAR}{hak-par'in oy sayisi, the number of votes the Rights and Freedoms Party (HAK-PAR) received in each province}
#'   \item{HAK-PAR_\%}{hak-par'in oy yuzdesi, the percentage of votes the Rights and Freedoms Party (HAK-PAR) received in each province}
#'   \item{LDP}{ldp'nin oy sayisi, the number of votes the Liberal Democratic Party (LDP) received in each province}
#'   \item{LDP_\%}{ldp'nin oy yuzdesi, the percentage of votes the Liberal Democratic Party (LDP) received in each province}
#'   \item{BDP}{bdp'nin oy sayisi, the number of votes the Peace and Democracy Party (BDP) received in each province}
#'   \item{BDP_\%}{bdp'nin oy yuzdesi, the percentage of votes the Peace and Democracy Party (BDP) received in each province}
#'   \item{BTP}{btp'nin oy sayisi, the number of votes the Independent Turkey Party (BTP) received in each province}
#'   \item{BTP_\%}{btp'nin oy yuzdesi, the percentage of votes the Independent Turkey Party (BTP) received in each province}
#'   \item{IP}{ip'nin oy sayisi, the number of votes the Workers' Party (IP) received in each province}
#'   \item{IP_\%}{ip'nin oy yuzdesi, the percentage of votes the Workers' Party (IP) received in each province}
#'   \item{HDP}{hdp'nin oy sayisi, the number of votes the Peoples' Democratic Party (HDP) received in each province}
#'   \item{HDP_\%}{hdp'nin oy yuzdesi, the percentage of votes the Peoples' Democratic Party (HDP) received in each province}
#'   \item{CHP}{chp'nin oy sayisi, the number of votes the Republican People's Party (CHP) received in each province}
#'   \item{CHP_\%}{chp'nin oy yuzdesi, the percentage of votes the Republican People's Party (CHP) received in each province}
#'   \item{HEPAR}{hepar'in oy sayisi, the number of votes the Rights and Equality Party (HEPAR) received in each province}
#'   \item{HEPAR_\%}{hepar'in oy yuzdesi, the percentage of votes the Rights and Equality Party (HEPAR) received in each province}
#'   \item{MHP}{mhp'nin oy sayisi, the number of votes the Nationalist Movement Party (MHP) received in each province}
#'   \item{MHP_\%}{mhp'nin oy yuzdesi, the percentage of votes the Nationalist Movement Party (MHP) received in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY}{bagimsiz adaylarin toplam oy sayisi, the total number of votes received by independent candidates in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY_\%}{bagimsiz adaylarin toplam oy yuzdesi, the total percentage of votes received by independent candidates in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2014_il"


#' Information for the results of the local elections in Turkey by province in 2019, detailing votes for each party
#'
#' A dataset showing detailed information for each political party competing in the local elections in every province, including vote counts, vote percentages, and overall voting statistics.
#'
#' @format A data frame with rows for each of the 81 provinces and 31 variables:
#' \describe{
#'   \item{Il_Adi}{il adi, the name of the province}
#'   \item{Kayitli_Secmen_Sayisi}{kayitli secmen sayisi, the number of registered voters in each province}
#'   \item{Oy_Kullanan_Secmen_Sayisi}{oy kullanan secmen sayisi, the number of voters who voted in each province}
#'   \item{Gecerli_Oy_Toplami}{gecerli oy toplami, the total number of valid votes in each province}
#'   \item{SAADET}{saadet partisinin oy sayisi, the number of votes the Felicity Party (SAADET) received in each province}
#'   \item{BTP}{btp'nin oy sayisi, the number of votes the Independent Turkey Party (BTP) received in each province}
#'   \item{TKP}{tkp'nin oy sayisi, the number of votes the Communist Party of Turkey (TKP) received in each province}
#'   \item{VATAN_PARTISI}{vatan partisinin oy sayisi, the number of votes the Homeland Party (VATAN PARTISI) received in each province}
#'   \item{BBP}{bbp'nin oy sayisi, the number of votes the Great Unity Party (BBP) received in each province}
#'   \item{CHP}{chp'nin oy sayisi, the number of votes the Republican People's Party (CHP) received in each province}
#'   \item{AK_PARTI}{ak parti'nin oy sayisi, the number of votes the Justice and Development Party (AK PARTI) received in each province}
#'   \item{DP}{dp'nin oy sayisi, the number of votes the Democratic Party (DP) received in each province}
#'   \item{MHP}{mhp'nin oy sayisi, the number of votes the Nationalist Movement Party (MHP) received in each province}
#'   \item{IYI_PARTI}{iyi parti'nin oy sayisi, the number of votes the Good Party (IYI PARTI) received in each province}
#'   \item{HDP}{hdp'nin oy sayisi, the number of votes the Peoples' Democratic Party (HDP) received in each province}
#'   \item{DSP}{dsp'nin oy sayisi, the number of votes the Democratic Left Party (DSP) received in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY}{bagimsiz adaylarin toplam oy sayisi, the total number of votes received by independent candidates in each province}
#'   \item{Il_Adi_\%}{il adinin yuzdesi, the percentage of the total vote in each province}
#'   \item{SAADET_\%}{saadet partisinin oy yuzdesi, the percentage of votes the Felicity Party (SAADET) received in each province}
#'   \item{BTP_\%}{btp'nin oy yuzdesi, the percentage of votes the Independent Turkey Party (BTP) received in each province}
#'   \item{TKP_\%}{tkp'nin oy yuzdesi, the percentage of votes the Communist Party of Turkey (TKP) received in each province}
#'   \item{VATAN_PARTISI_\%}{vatan partisinin oy yuzdesi, the percentage of votes the Homeland Party (VATAN PARTISI) received in each province}
#'   \item{BBP_\%}{bbp'nin oy yuzdesi, the percentage of votes the Great Unity Party (BBP) received in each province}
#'   \item{CHP_\%}{chp'nin oy yuzdesi, the percentage of votes the Republican People's Party (CHP) received in each province}
#'   \item{AK_PARTI_\%}{ak parti'nin oy yuzdesi, the percentage of votes the Justice and Development Party (AK PARTI) received in each province}
#'   \item{DP_\%}{dp'nin oy yuzdesi, the percentage of votes the Democratic Party (DP) received in each province}
#'   \item{MHP_\%}{mhp'nin oy yuzdesi, the percentage of votes the Nationalist Movement Party (MHP) received in each province}
#'   \item{IYI_PARTI_\%}{iyi parti'nin oy yuzdesi, the percentage of votes the Good Party (IYI PARTI) received in each province}
#'   \item{HDP_\%}{hdp'nin oy yuzdesi, the percentage of votes the Peoples' Democratic Party (HDP) received in each province}
#'   \item{DSP_\%}{dsp'nin oy yuzdesi, the percentage of votes the Democratic Left Party (DSP) received in each province}
#'   \item{BAGIMSIZ_TOPLAM_OY_\%}{bagimsiz adaylarin toplam oy yuzdesi, the total percentage of votes received by independent candidates in each province}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2019_il"

#' Information for the overall results of the local elections in Turkey in 2019, focusing on total vote percentages and mayoral positions won by parties
#'
#' A dataset showing the information for political parties competing in the local elections, their total votes, vote percentages, and the number of municipal and metropolitan mayoral positions won nationwide.
#'
#' @format A data frame with rows for each political party and 6 variables:
#' \describe{
#'   \item{Parti}{parti, the name of the political party}
#'   \item{Genel_baskani}{genel baskani, the general chairperson of the political party}
#'   \item{Oy}{oy, the total number of votes received by the party nationwide}
#'   \item{Yuzde}{yuzde, the percentage of total votes received by the party nationwide}
#'   \item{B.Belediye_Baskanligi_Sayisi}{buyuksehir belediye baskanligi sayisi, the number of metropolitan mayoral positions won by the party nationwide}
#'   \item{Belediye_Baskanligi_Sayisi}{belediye baskanligi sayisi, the number of municipal mayoral positions won by the party nationwide}
#' }
#' @source {YSK (Supreme Election Council)}
"yerel_secim_2019_buyuksehir_turkiye"


