\name{turf.args}
\alias{turf.args}
\title{Arguments used in TURF Analysis}
\description{INTERNAL: A list of named arguments that can be passed into \code{turf} and \code{turf.combos} to control the behavior
  and output of the TURF algorithm.
}

\usage{
turf.args(depth=1L, keep=0, mc=FALSE, nsims=10000, psims=NULL, sort="d")
}

\arguments{
  \item{depth}{Scalar indicating \emph{depth of reach}, see Markowitz (2005). \code{depth} is an integer, greater than or equal to 1; 
    non-integer values are coerced using \code{floor(depth)}.
  }
  \item{keep}{Scalar indicating the number of combinations of each size to keep in the output object generated by \code{turf}. 
    \code{keep} is an integer, greater than or equal to zero; non-integer values are coerced using \code{floor(keep)}. If 
	\code{keep} == 0 (default), \emph{all} combinations evaluated by the TURF algorithm are kept; if \code{keep} >= 1, the lesser 
	of \code{keep} or the number of evaluated combinations of a given size are kept.
  }
  \item{mc}{Logical indicating whether or not Monte Carlo simulated subsets of combinations should be substituted for all possible
    combinations of \emph{n} choose \emph{k} or user-specified combinations. When TRUE, subsets are generated using the method described 
	by Adler, \emph{et al}. (2010), only when \code{nsims} is also less than \emph{n} choose \emph{k} or the number of user-specified
	combinations.
  }
  \item{nsims}{Scalar indicating the number of combination sets of a given size to generate when \code{mc} == TRUE. \code{nsims} is an 
    integer, greater than or equal to 1; non-integer values are coerced using \code{floor(nsims)}. This argument is ignored when 
	\code{mc} == FALSE.
  }
  \item{psims}{Vector of length \emph{n} indicating the probabilities of sampling each item into a combination set when \code{mc} == 
    TRUE. Probabilities need not sum to 1 (see \code{sample} for additional details). All values must be greater than or equal to 0;
    for combinations of size \emph{k}, there must be at least \emph{k} non-zero values in \code{psims}. Default varies depending on 
	calling function; when called from \code{turf}, default is the probability of each item being reached; when called from 
	\code{turf.combos}, default is \code{rep(1/n, n)}. \code{psims} is ignored when \code{mc} == FALSE.
  }
  \item{sort}{Character indicating sort order of TURF output: "d" (default) causes combinations to be sorted in descending order of
    reach, then frequency; "a" causes combinations to be sorted in ascending order of reach, then frequency; "n" leaves combinations 
	unsorted (i.e., they remain in the same order as the rows in each element of \code{combos}). \code{sort} is executed before 
	\code{keep}. When \code{sort} == "n", \code{keep} is ignored (i.e., all combinations evaluated are kept in the output). No other 
	values are permitted.
  }
}

\details{
  Defaults set by this function may be modified by specifying any of the arguments as name-value pairs in place of the \code{(...)} 
  argument when calling \code{turf} or \code{turf.combos}. It is never necessary to call \code{turf.args} directly.
} 

\value{
  A list consisting of the named arguments.
}

\references{
  Adler, T.J., Smith, C. & Dumont, J. 2010. Optimizing product portfolios using discrete choice modeling and TURF. In: S. Hess,
  A. Daly (Eds), \emph{Choice modeling: the state-of-the-art and the state-of-practice; proceedings from the Inaugural 
  International Choice Modeling Conference}. Emerald Publishing Group Ltd., pp. 485-497.
  
  Krieger, A.M. & Green, P.E. 2000. Turf revisited: Enhancements to toal unduplicated reach and frequency analysis. \emph{Marketing
  Research}, 12, 30-36.
  
  Markowitz, L. 2005. Going beyond TURF to complement and extend existing product lines. \emph{Ipsos-Insight}, November 2005.
  
  Miaoulis, G., Free, V. & Parsons, H. 1990. TURF: A new planning approach for product line extensions. \emph{Marketing Research},
  March, pp. 28-40.
}

\examples{
  ##INTERNAL USE ONLY
  
}