% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{tsvGenIndex}
\alias{tsvGenIndex}
\title{Produce a simple index of a tsv file.}
\usage{
tsvGenIndex(filename, indexfile)
}
\arguments{
\item{filename}{The name (and path) of the file(s) containing the data to index.}

\item{indexfile}{The name (and path) of the file(s) to which the index will be written.  There must
be exactly one index file for every filename.}
}
\value{
NULL. This function generates an index file.
}
\description{
This function reads a TSV file and produces an index to the start of each row.
The TSV file is required to have a header line and at least one data line.  The header line may
contain either the same number or one fewer columns than the data lines, which must all contain
the same number of columns.  The first column of each data line will be indexed.
}
\examples{
datafile = tempfile("data");
df <- data.frame(C1 = c("Foo", "Boing", "The"), C2 = c("Bar", "Boing", "End"));
rownames(df) <- c("R1", "R2", "R3");
write.table(df, file=datafile, sep="\t", quote=FALSE, row.names=TRUE, col.names=TRUE);
indexfile = tempfile("index");
tsvGenIndex (datafile, indexfile)

}
\seealso{
tsvGetLines, tsvGetData
}
