% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{theta}
\alias{theta}
\alias{forecast.theta}
\alias{plot.theta}
\alias{theta.thief}
\title{Theta method}
\usage{
theta(
  y,
  m = NULL,
  sign.level = 0.05,
  cost0 = c("MSE", "MdSE", "MAE", "MdAE"),
  cost2 = c("MSE", "MdSE", "MAE", "MdAE"),
  costs = c("MSE", "MdSE", "MAE", "MdAE"),
  multiplicative = c("multiplicative", "additive", "auto"),
  cma = NULL,
  outliers = NULL
)

\method{forecast}{theta}(object, h = NULL, ...)

\method{plot}{theta}(x, thetalines = c(TRUE, FALSE), ...)

theta.thief(y, h = NULL, ...)
}
\arguments{
\item{y}{input time series. Can be \code{ts} object.}

\item{m}{seasonal period. If \code{y} is a \code{ts} object then the default is its frequency.}

\item{sign.level}{significance level for trend and seasonality tests.}

\item{cost0}{cost function of theta0 line. Can be:
\itemize{
\item{\code{"MSE"}}{: mean squared error.}
\item{\code{"MdSE"}}{: median squared error.}
\item{\code{"MAE"}}{: mean absolute error.}
\item{\code{"MdAE"}}{: median absolute error.}
}}

\item{cost2}{cost function of theta2 line. Same options as \code{cost0}.}

\item{costs}{cost function of seasonal element. Same options as \code{cost0}.}

\item{multiplicative}{type of seasonal decomposition. This can be \code{"multiplicative"}, \code{"additive"} or \code{"auto"}. If \code{y} contains non-positive values then this is forced to \code{"additive"}.}

\item{cma}{input precalculated level/trend for the analysis. Use \code{NULL} to estimate internally.}

\item{outliers}{provide vector of location of observations that are considered outliers (see \code{\link{residout}}). These will be considered in the estimation of theta0. For no outliers use \code{NULL}.}

\item{object}{object of class \code{theta}.}

\item{h}{forecast horizon. If \code{h} is \code{NULL}, then the horizon is set equal to the the seasonal frequency.}

\item{...}{additional arguments passed to functions.}

\item{x}{object of class \code{theta}.}

\item{thetalines}{if \code{TRUE}, then theta lines are included in the plot.}
}
\value{
An object of class \code{theta}, containing:
\itemize{
\item{\code{"method"}}{: "Theta".}
\item{\code{"y"}}{: the input time series.}
\item{\code{"m"}}{: seasonal periods.}
\item{\code{"exist"}}{: Statistical testing results, \code{exist[1]} is the result for trend, \code{exist[2]} is for season.}
\item{\code{"multiplicative"}}{: If \code{TRUE}, then seasonality is modelled multiplicatively.}
\item{\code{"theta0"}}{: fitted theta0 line values.}
\item{\code{"theta2"}}{: fitted theta2 line values.}
\item{\code{"season"}}{: fitted season values.}
\item{\code{"x.out"}}{: modelled outliers.}
\item{\code{"cost"}}{: cost functions for theta0, theta2 and season components.}
\item{\code{"a"}}{: SES parameters of theta2.}
\item{\code{"b"}}{: regression parameters of theta0.}
\item{\code{"p"}}{: coefficients of outliers from theta0 and theta2 estimation.}
\item{\code{"g"}}{: pure seasonal exponential smoothing parameters.}
\item{\code{"fitted"}}{: fitted values.}
\item{\code{"residuals"}}{: in-sample residuals.}
\item{\code{"MSE"}}{: in-sample Mean Squared Error.}
}
}
\description{
Estimate Theta method.

Forecast with fitted Theta method.

Produce a plot of the fitted Theta method.
}
\details{
This implementation of the Theta method tests automatically for seasonality and trend. Seasonal decomposition can be done either additively or multiplicatively and the seasonality is treated as a pure seasonal model. The various Theta components can be optimised using different cost functions. The originally proposed Theta method always assumed multiplicative seasonality and presence of trend, while all theta lines were optimised using MSE and seasonality was estimated using classical decomposition.
}
\section{Functions}{
\itemize{
\item \code{theta.thief}: Wrapper function to use Theta with \code{\link[thief]{thief}}.
}}

\examples{
fit <- theta(referrals)
plot(fit)

forecast.theta(fit,h=12) # Or simply use forecast(fit)

\dontrun{
library(thief)
thief(referrals,forecastfunction=theta.thief)
}

}
\references{
\itemize{
\item{The original Theta method was proposed by: Assimakopoulos, V., & Nikolopoulos, K. (2000). The theta model: a decomposition approach to forecasting. International journal of forecasting, 16(4), 521-530. See details in how the implementation here differs.}
\item{The THieF forecasting methodology used for \code{theta.thief} is proposed by: Athanasopoulos, G., Hyndman, R. J., Kourentzes, N., & Petropoulos, F. (2017). Forecasting with temporal hierarchies. European Journal of Operational Research, 262(1), 60-74.}
}
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
