% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSthief.R
\name{plotSthief}
\alias{plotSthief}
\title{Plot temporal hierarchy}
\usage{
plotSthief(y, labels = c(TRUE, FALSE), ...)
}
\arguments{
\item{y}{input time series (a \code{ts} object) or an integer.}

\item{labels}{if \code{TRUE} labels will be added for the temporal aggregation levels if the seasonal period is 4 (quarters), 7 (days in a week), 12 (months), 24 (hours), 48 (half-hours), 52 (weeks) or 364 (days).}

\item{...}{additional arguments passed to the plotting function.}
}
\value{
Produces a plot of the temporal hierarchy.
}
\description{
Plots the temporal hierarchy for a given time series of seasonal periodicity.
}
\examples{
plotSthief(AirPassengers)

}
\references{
Athanasopoulos, G., Hyndman, R. J., Kourentzes, N., & Petropoulos, F. (2017). \href{http://kourentzes.com/forecasting/2017/02/27/forecasting-with-temporal-hierarchies-3/}{Forecasting with temporal hierarchies}. European Journal of Operational Research, 262(1), 60-74.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
