% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass_v3.R
\name{mass_v3}
\alias{mass_v3}
\title{Calculates the distance profile using MASS_V3 algorithm}
\usage{
mass_v3(
  query_window,
  data,
  window_size,
  data_size,
  data_mean,
  data_sd,
  query_mean,
  query_sd,
  k = NULL,
  ...
)
}
\arguments{
\item{query_window}{a \code{vector} of \code{numeric}. Query window.}

\item{data}{a \code{matrix} or a \code{vector}.}

\item{window_size}{an \code{int}. Sliding window size.}

\item{data_size}{an \code{int}. The length of the reference data.}

\item{data_mean}{precomputed data moving average.}

\item{data_sd}{precomputed data moving standard deviation.}

\item{query_mean}{precomputed query average.}

\item{query_sd}{precomputed query standard deviation.}

\item{k}{an \code{int} or \code{NULL}. Default is \code{NULL}. Defines the size of batch. Prefer to use a power of 2.}

\item{\dots}{just a placeholder to catch unused parameters.}
}
\value{
Returns the \code{distance_profile} for the given query and the \code{last_product} for STOMP
algorithm.
}
\description{
Mueen's Algorithm for Similarity Search is The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance and Correlation Coefficient.
}
\details{
This is a piecewise version of MASS that performs better when the size of the pieces are well
aligned with the hardware.
}
\examples{
w <- mp_toy_data$sub_len
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 1]
d_size <- length(ref_data)
q_size <- length(query_data)

pre <- tsmp:::mass_pre(ref_data, query_data, w)

dp <- list()
for (i in 1:(d_size - w + 1)) {
  dp[[i]] <- tsmp:::mass_v3(
    query_data[i:(i - 1 + w)], ref_data,
    pre$window_size, pre$data_size, pre$data_mean, pre$data_sd,
    pre$query_mean[i], pre$query_sd[i]
  )
}
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_pre]{mass_pre()}} to precomputation of input values.
}
