% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluss.R
\name{floss_cac}
\alias{floss_cac}
\title{FLOSS - Corrected Arc Counts}
\usage{
floss_cac(.mp, data_window, exclusion_zone = NULL)
}
\arguments{
\item{.mp}{a \code{MatrixProfile} object.}

\item{data_window}{an \code{int}. Sets the size of the buffer used to keep track of semantic changes.}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}
}
\value{
Returns the input \code{.mp} object a new name \code{cac} with the corrected arc count and \code{cac_final}
the combination of \code{cac} after repeated calls of \code{floss()}.
}
\description{
Computes the arc count with edge and 'online' correction (CAC).
}
\details{
Original paper suggest using the classic statistical-process-control heuristic to set a threshold
where a semantic change may occur in CAC. This may be useful in real-time implementation as we don't
know in advance the number of domain changes to look for. Please check original paper (1).
}
\examples{
data <- mp_fluss_data$tilt_abp$data[1:1000]
new_data <- mp_fluss_data$tilt_abp$data[1001:1010]
w <- 10
mp <- tsmp(data, window_size = w, verbose = 0)
data_window <- 1000
mp <- stompi_update(mp, new_data, data_window)
mp <- floss_cac(mp, data_window)
}
\references{
\itemize{
\item Gharghabi S, Ding Y, Yeh C-CM, Kamgar K, Ulanova L, Keogh E. Matrix Profile VIII: Domain Agnostic Online Semantic Segmentation at Superhuman Performance Levels. In: 2017 IEEE International Conference on Data Mining (ICDM). IEEE; 2017. p. 117-26.
}

Website: \url{https://sites.google.com/site/onlinesemanticsegmentation/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Semantic Segmentations: 
\code{\link{floss_extract}()},
\code{\link{floss}()},
\code{\link{fluss_cac}()},
\code{\link{fluss_extract}()},
\code{\link{fluss_score}()},
\code{\link{fluss}()}
}
\concept{Semantic Segmentations}
