% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluss.R
\name{fluss_extract}
\alias{fluss_extract}
\title{FLUSS - Extract Segments}
\usage{
fluss_extract(.mpac, num_segments = 1, exclusion_zone = NULL)
}
\arguments{
\item{.mpac}{a TSMP object of class \code{ArcCount}.}

\item{num_segments}{an \code{int}. Number of segments to extract. Based on domain knowledge.}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}
}
\value{
Returns the input \code{.mp} object a new name \code{fluss} with the location of semantic changes.
}
\description{
Extract candidate points of semantic changes.
}
\examples{
data <- mp_fluss_data$tilt_abp$data[1:1000]
w <- 10
mp <- tsmp(data, window_size = w, verbose = 0)
mp <- fluss_cac(mp)
mp <- fluss_extract(mp, 2)
}
\references{
\itemize{
\item Gharghabi S, Ding Y, Yeh C-CM, Kamgar K, Ulanova L, Keogh E. Matrix Profile VIII:
Domain Agnostic Online Semantic Segmentation at Superhuman Performance Levels. In: 2017 IEEE
International Conference on Data Mining (ICDM). IEEE; 2017. p. 117–26.
}

Website: \url{https://sites.google.com/site/onlinesemanticsegmentation/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Semantic Segmentations: \code{\link{floss_cac}},
  \code{\link{floss_extract}}, \code{\link{floss}},
  \code{\link{fluss_cac}}, \code{\link{fluss_score}},
  \code{\link{fluss}}
}
\concept{Semantic Segmentations}
