% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.R
\name{simple_fast}
\alias{simple_fast}
\title{Compute the join similarity for Sound data}
\usage{
simple_fast(..., window_size, exclusion_zone = 1/2, verbose = 2)
}
\arguments{
\item{...}{a \code{matrix} of \code{numeric}, where each column is a time series. Accepts \code{list} and
\code{data.frame} too. If a second time series is supplied it will be a join matrix profile.}

\item{window_size}{an \code{int} with the size of the sliding window.}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window size (default is
\code{1/2}).}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns a \code{SimpleMatrixProfile} object, a \code{list} with the matrix profile \code{mp}, profile index \code{pi},
window size \code{w} and exclusion zone \code{ez}.
}
\description{
Compute the join similarity for Sound data
}
\details{
\code{verbose} changes how much information is printed by this function; \code{0} means nothing, \code{1} means
text, \code{2} means text and sound.
}
\examples{
w <- 30
data <- mp_toy_data$data # 3 dimensions matrix
result <- simple_fast(data, window_size = w, verbose = 0)

}
\references{
\itemize{
\item Silva D, Yeh C, Batista G, Keogh E. Simple: Assessing Music Similarity Using
Subsequences Joins. Proc 17th ISMIR Conf. 2016;23–30.
}

\itemize{
\item Silva DF, Yeh C-CM, Zhu Y, Batista G, Keogh E. Fast Similarity Matrix Profile for
Music Analysis and Exploration. IEEE Trans Multimed. 2018;14(8):1–1.
}

Website: \url{https://sites.google.com/view/simple-fast}

Website: \url{https://sites.google.com/site/ismir2016simple/home}
}
