% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.tsgarch.estimate}
\alias{confint.tsgarch.estimate}
\alias{confint}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{tsgarch.estimate}(object, parm, level = 0.95, vcov_type = "H", ...)
}
\arguments{
\item{object}{an object of class tsgarch.estimate.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
either a vector of numbers or a vector of names. If missing, all parameters
are considered.}

\item{level}{the confidence level required.}

\item{vcov_type}{valid choices are \dQuote{H} for using the analytic hessian
for the bread, \dQuote{OP} for the outer product of gradients, \dQuote{QMLE}
for the Quasi-ML sandwich estimator (Huber-White), and \dQuote{NW} for the Newey-West
adjusted sandwich estimator (a HAC estimator).}

\item{...}{additional parameters passed to the Newey-West bandwidth function to
determine the optimal lags.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2
in \% (by default 2.5\% and 97.5\%).
}
\description{
Confidence Intervals for Model Parameters
}
