% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as_flextable.summary.tsgarch.estimate}
\alias{as_flextable.summary.tsgarch.estimate}
\title{Transform a summary object into flextable}
\usage{
\method{as_flextable}{summary.tsgarch.estimate}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.symbols = TRUE,
  include.equation = TRUE,
  include.statistics = TRUE,
  table.caption = paste0(toupper(x$model), " Model Summary"),
  ...
)
}
\arguments{
\item{x}{an object of class \dQuote{summary.tsgarch}.}

\item{digits}{integer, used for number formatting. Optionally, to avoid
scientific notation, set \sQuote{options(scipen=999)}.}

\item{signif.stars}{logical. If TRUE, ‘significance stars’ are printed for each coefficient.}

\item{include.symbols}{logical. If TRUE, replaces parameter names with their symbols (if they exist).}

\item{include.equation}{logical. If TRUE, adds a section with the symbolic model equation.}

\item{include.statistics}{logical. If TRUE, adds a section with summary statistics on the model.}

\item{table.caption}{an optional string for the table caption.}

\item{...}{additional arguments passed to flextable method.}
}
\value{
A flextable object.
}
\description{
Transforms a \dQuote{summary.tsgarch} object into a flextable
with options on symbolic representation and model equation.
}
