% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{plot.dec.sim}
\alias{plot.dec.sim}
\title{plot simulation results from a dec.sim object}
\usage{
\method{plot}{dec.sim}(x, pt, s = 1, type = c("all", "s", "prob", "np",
  "dlt"), label = TRUE, col = "cornflowerblue", text.col = "darkblue",
  cex = 1, ...)
}
\arguments{
\item{x}{an object of class \code{"dec.sim"} or \code{"sl.sim"}, a result of a call to \code{dec.sim} or \code{sl.sim}.}

\item{pt}{a vector with target toxicity for each scenario.}

\item{s}{scenario to be plotted. Defaults to 1.}

\item{type}{plot type. See descriptions above.}

\item{label}{a logical value indicating if values are shown on plot.}

\item{col}{graphical parameter \code{col}; see details \code{\link{par}}.}

\item{text.col}{plotting color of text shown.}

\item{cex}{graphical parameter \code{col}; see details \code{\link{par}}.}

\item{...}{arguments to be passed to \code{\link{plot}} methods.}
}
\description{
Three plots are currently available: a plot of true toxicity at each dose level (\code{type = "s"}); a bar plot of the probability of selecting as the MTD for each dose level (\code{type = "prob"}); a bar plot of the average number of patients treated at each dose level (\code{type = "np"}); a bar plot of the average number of patients experienced DLT at each dose level (\code{type = "dlt"}) and \code{type = "all"} generates all above plots.
}
\examples{
# generate decision table
dt <- dec.table(0.6,0.4,0.2,0.3,0.3,c(3,3,3))
# simulate trials from test data 
test.file <- system.file("extdata", "testS.csv", package = "tsdf")
out <- sl.sim(dt$table, test.file)
plot(out, pt=rep(0.3,2), s=1, type="all")
plot(out, pt=rep(0.3,2), s=2, type="prob")
plot(out, pt=rep(0.3,2), s=1, type="np")
plot(out, pt=rep(0.3,2), s=2, type="dlt")
}
