% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specialfun.r
\name{missls}
\alias{missls}
\title{\code{missls} substitutes missing values in a time series using the LS approach with ARMA models}
\source{
S. R. Brubacher and G. Tunnicliffe Wilson (1976)   <https://www.jstor.org/stable/2346678>  "Interpolating Time Series with Application to the 
   Estimation of Holiday Effects on Electricity Demand Journal of the Royal Statistical Society"
}
\usage{
missls(x, p = 0, tol = 0.001, theo = 0)
}
\arguments{
\item{x}{vector, the time series}

\item{p}{integer, the  order of polynom   alpha(B)/beta(B)}

\item{tol}{tolerance that can be set; it enters via tol*sd(x,na.rm=TRUE)}

\item{theo}{(k,1)-vector, prespecified Inverse ACF, IACF (starting at lag 1)}
}
\value{
y    completed time series
}
\description{
\code{missls} substitutes missing values in a time series using the LS approach with ARMA models
}
\examples{
data(HEARTBEAT)
x <- HEARTBEAT
x[c(20,21)] <- NA
out <-  missls(x,p=2,tol=0.001,theo=0)
}
