% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlVar-methods.R
\name{fitted.nlVar}
\alias{fitted.nlVar}
\alias{fitted}
\title{fitted method for objects of class nlVar, i.e. VAR and VECM models.}
\usage{
\method{fitted}{nlVar}(object, level = c("model", "original"), ...)
}
\arguments{
\item{object}{An object of class \sQuote{nlVar}; generated by
\code{\link{VECM}} or \code{\link{lineVar}}.}

\item{level}{How to return the fitted values. See below.}

\item{\dots}{Currently not used.}
}
\value{
A matrix.
}
\description{
Returns the fitted values of the model, either as computed in the model, or
back to the original series level.
}
\details{
In case of a VAR in differences, in ADF specification, or a VECM, the fitted
values are actually in differences. With the option \code{level="original"},
the function returns the series in the original level.

For VAR in levels, the two arguments are evidently the same and hence it is
not taken into account, returning a warning.
}
\examples{


## estimate models
data(barry)

ve <- VECM(barry, lag=2)
va <- lineVar(barry, lag=1)
va_diff <- lineVar(barry, lag=1, I="diff")
va_ADF <- lineVar(barry, lag=1, I="ADF")


## get fitted values:
tail(fitted(ve))
tail(fitted(ve, level="original"))

tail(fitted(va))
tail(fitted(object=va, level="original"))

tail(fitted(va_diff))
tail(fitted(object=va_diff, level="original"))

tail(fitted(va_ADF))
tail(fitted(object=va_ADF, level="original"))


}
\author{
Matthieu Stigler
}
\keyword{regression}
