\name{fevd}

\alias{fevd}

\alias{fevd.nlVar}

\title{Forecast Error Variance Decomposition}

\encoding{latin1}

\description{
  Use the \code{fevd} function from package \pkg{vars} to compute the forecast error variance decomposition 
  of a VAR(p) or VECM for \code{n.ahead} steps. 
}

\usage{
\method{fevd}{nlVar}(x, n.ahead=10, ...)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{VAR}}  generated by
    \command{lineVar()}, or an object of class \sQuote{\code{VECM}}
    generated by \command{VECM()}}.
  \item{n.ahead}{Integer specifying the number of steps.}
  \item{...}{Currently not used.}
}

\details{
The function converts the VAR or VECM computed by package tsDyn into 
an object of class \sQuote{\code{vec2var}}, on which then the \code{\link[vars]{fevd}}
method is applied. For details, see  package \pkg{vars}. 
  
}

\value{
  A list with class attribute \sQuote{\code{varfevd}} of length \code{K}
  holding the forecast error variances as matrices.
}  
\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Lütkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{plot}} for the plot method. \code{\link{lineVar}}, \code{\link{VECM}} for the models. 
  
}

\examples{
data(zeroyld)
mod_vecm <- VECM(zeroyld, lag = 2)
fevd(mod_vecm, n.ahead = 5)
}


\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{fevd}
\concept{forecast error variance decomposition}
\concept{VECM}
