\name{setar.sim}
\alias{setar.sim}
\title{Simulation and bootstrap of Treshold Autoregressive model}
\description{
Simulate or bootstrap a Threshold VAR
}
\usage{
setar.sim(data,B, setarObject, n=200, lag=1, trend=TRUE, nthresh=0, thDelay=0, Thresh, type=c("boot", "simul", "check"), starting=NULL, rand.gen = rnorm, innov = rand.gen(n, ...),...)
}
\value{
a list with the simulated/bootstraped data and the parameter matrix used. 
}
\arguments{
\item{data}{ univariate time series }
\item{B}{vector of coefficients to simulate}
\item{setarObject}{Object of class linear or setar to be bootstrapped}
\item{n}{Number of observations to create when type="simul"}
\item{Thresh}{The threshold value(s). Vector of length nthresh}
\item{nthresh}{number of threshold (see details)}
\item{lag}{Number of lags to include in each regime}
\item{type}{Whether a bootstrap or simulation is to employ. See details}
\item{trend}{If a trend should be included in the model}
\item{thDelay}{'time delay' for the threshold variable (as multiple of embedding time delay d). }
\item{starting}{Starting values when a simulation with given parameter matrix is made}
\item{rand.gen}{optional: a function to generate the innovations.}
\item{innov}{an optional times series of innovations.  If not provided, \code{rand.gen} is used.}
\item{\dots}{additional arguments for \code{rand.gen}.  Most usefully, the standard deviation of the innovations generated by \code{rnorm} can be specified by \code{sd}.}
}
\details{
This function offers the possibility to generate series following a TAR from two approaches: bootstrap or simulation. When the data is given, one can use a simple residual bootstrap or simulate a serie from the parameter matrix and with normal distributed residuals (with variance pre-specified). The choice "check" is just there to check the function: one should obtain the same values as the given values. Please report if different. 
When the parameter matrix is given, there is only the possibility to simulate series. The starting values (of length equal to the number of lags) can be given. The user should take care for the choice of the starting values and parameters values, since it is not sure that the simulated values will cross the threshold even once.
}
\seealso{
\code{\link{SETAR}} to estimate a SETAR, \code{\link{arima.sim}} to simulate an ARMA.
}
\author{Matthieu Stigler}
\examples{
##Simulation of a TAR with 1 threshold
sim<-setar.sim(B=c(2.9,-0.4,-0.1,-1.5, 0.2,0.3),lag=2, type="simul", nthresh=1, Thresh=2, starting=c(2.8,2.2))$serie
mean(ifelse(sim>2,1,0))	#approximation of values over the threshold

#check the result
selectSETAR(sim, m=2)

##Bootstrap a TAR with two threshold (three regimes)
sun<-(sqrt(sunspot.year+1)-1)*2
setar.sim(data=sun,nthresh=2,n=500, type="boot", Thresh=c(6,9))$serie

##Check the bootstrap
cbind(setar.sim(data=sun,nthresh=2,n=500, type="check", Thresh=c(6,9))$serie,sun)
}
\keyword{ ts }


