% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joins.R
\name{filter_stops}
\alias{filter_stops}
\title{Get a set of stops for a given set of service ids and route ids}
\usage{
filter_stops(gtfs_obj, service_ids, route_ids)
}
\arguments{
\item{gtfs_obj}{as read by read_gtfs()}

\item{service_ids}{the service for which to get stops}

\item{route_ids}{the route_ids for which to get stops}
}
\value{
stops for a given service
}
\description{
Get a set of stops for a given set of service ids and route ids
}
\examples{
\donttest{
local_gtfs_path <- system.file("extdata", "google_transit_nyc_subway.zip", package = "trread")
nyc <- read_gtfs(local_gtfs_path,local=TRUE)
select_service_id <- filter(nyc$calendar_df,monday==1) \%>\% pull(service_id)
select_route_id <- sample_n(nyc$routes_df,1) \%>\% pull(route_id)
filtered_stops_df <- filter_stops(nyc,select_service_id,select_route_id)
}
}
