% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorKeySextant}
\alias{ColorKeySextant}
\title{Sextant Scheme Legend}
\usage{
ColorKeySextant(
  center,
  values,
  label_as,
  show_center,
  limits = matrix(0:1, nrow = 2, ncol = 3)
)
}
\arguments{
\item{center}{Ternary coordinates of the sextant meeting point.}

\item{values}{6 element character vector of rgb-codes.}

\item{label_as}{"pct" for percent-share labels or "pct_diff" for
percent-point-difference from center labels.}

\item{show_center}{Should the center be marked on the legend? (logical)}

\item{limits}{A 2 by 3 matrix of lower and upper limits for p1, p2 and p3.}
}
\value{
A ggtern grob.
}
\description{
Plot a sextant scheme legend.
}
\examples{
tricolore:::ColorKeySextant(center = prop.table(runif(3)),
                           values = c('#01A0C6', '#B8B3D8', '#F11D8C',
                                      '#FFB3B3', '#FFFF00', '#B3DCC3'),
                           label_as = 'pct_diff', show_center = TRUE)

}
\keyword{internal}
