% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorMap}
\alias{ColorMap}
\title{RGB Mixture of Ternary Composition}
\usage{
ColorMap(P, breaks, h_, c_, l_, contrast, center, spread)
}
\arguments{
\item{P}{n by 3 matrix of ternary compositions {p1, p2, p3}_i for
i=1, ..., n.}

\item{breaks}{Number of breaks in the discrete color scale. An integer >0.
Values above 99 imply no discretization.}

\item{h_}{Primary hue of the first ternary element in angular degrees [0, 360].}

\item{c_}{Maximum possible chroma of mixed colors [0, 200].}

\item{l_}{Lightness of mixed colors [0, 100].}

\item{contrast}{Lightness contrast of the color scale [0, 1).}

\item{center}{Ternary coordinates of the grey-point.}

\item{spread}{Spread of the color scale around center > 0.}
}
\value{
An n row data frame giving, for each row of the input P, the input
proportions (p1, p2, p3), parameters of the color mixture (h, c, l) and the
hexsrgb string of the mixed colors.
}
\description{
Return the ternary balance scheme colors for a matrix of ternary compositions.
}
\examples{
P <- prop.table(matrix(runif(9), ncol = 3), 1)
tricolore:::ColorMap(P, breaks = 5, h_ = 80, c_ = 170, l_ = 80,
                     contrast = 0.6, center = rep(1/3, 3), spread = 1)

}
\keyword{internal}
