% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{PowerScale}
\alias{PowerScale}
\title{Compositional Powering}
\usage{
PowerScale(P, scale = 1)
}
\arguments{
\item{P}{n by m matrix of compositions {p1, ..., pm}_i for i=1,...,n.}

\item{scale}{Power scalar.}
}
\value{
n by m matrix of powered compositions.
}
\description{
Raise a compositional data-set to a given power.
}
\examples{
P <- prop.table(matrix(runif(12), 4), margin = 1)
tricolore:::PowerScale(P, 2)

}
\references{
Pawlowsky-Glahn, V., Egozcue, J. J., & Tolosana-Delgado, R. (2007). Lecture
Notes on Compositional Data Analysis. Retrieved from
https://dugi-doc.udg.edu/bitstream/handle/10256/297/CoDa-book.pdf
}
\keyword{internal}
