% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{trending_model_fit-prediction}
\alias{trending_model_fit-prediction}
\alias{predict.trending_model_fit}
\alias{predict.trending_model_fit_list}
\title{Predict methods}
\usage{
\method{predict}{trending_model_fit}(
  object,
  new_data,
  alpha = 0.05,
  add_pi = TRUE,
  simulate_pi = TRUE,
  uncertain = TRUE,
  ...
)

\method{predict}{trending_model_fit_list}(
  object,
  new_data,
  alpha = 0.05,
  add_pi = TRUE,
  simulate_pi = TRUE,
  uncertain = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{trending_model_fit} or \code{trending_model_fit_list} object.}

\item{new_data}{A \code{data.frame} containing data for which predictions are to
be derived.}

\item{alpha}{The alpha threshold to be used for prediction intervals,
defaulting to 0.05, i.e. 95\% prediction intervals are derived.}

\item{add_pi}{Add a prediction interval to the output. Default TRUE.}

\item{simulate_pi}{Should the ciTools package be used to simulate prediction
intervals for glm models.  Default TRUE.}

\item{uncertain}{Only used for glm models.  Default TRUE.  If FALSE
uncertainty in the fitted paramaters is ignored when generating the
prediction intervals.}

\item{...}{Not currently used.

x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)

poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)

fitted_poisson <- fit(poisson_model, dat)
fitted_list <- fit(list(poisson_model, negbin_model), dat)

predict(fitted_poisson)
predict(fitted_list)}
}
\description{
These functions can be used to generated estimated values and associated
confidence/prediction intervals for trending_model_fit objects.
}
