% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{ranges}
\alias{ranges}
\alias{range}
\alias{range_start_byte}
\alias{range_start_point}
\alias{range_end_byte}
\alias{range_end_point}
\alias{is_range}
\title{Ranges}
\usage{
range(start_byte, start_point, end_byte, end_point)

range_start_byte(x)

range_start_point(x)

range_end_byte(x)

range_end_point(x)

is_range(x)
}
\arguments{
\item{start_byte, end_byte}{\verb{[double(1)]}

0-indexed bytes for the start and end of the range, respectively.}

\item{start_point, end_point}{\verb{[tree_sitter_point]}

0-indexed points for the start and end of the range, respectively.}

\item{x}{\verb{[tree_sitter_range]}

A range.}
}
\value{
\itemize{
\item \code{range()} returns a new range.
\item \code{range_start_byte()} and \code{range_end_byte()} return a single double.
\item \code{range_start_point()} and \code{range_end_point()} return a \code{\link[=point]{point()}}.
\item \code{is_range()} returns \code{TRUE} or \code{FALSE}.
}
}
\description{
\itemize{
\item \code{range()} creates a new tree-sitter range.
\item \code{range_start_byte()} and \code{range_end_byte()} access a range's start and
end bytes, respectively.
\item \code{range_start_point()} and \code{range_end_point()} access a range's start and
end points, respectively.
\item \code{is_range()} determines whether or not an object is a range.
}

Note that the bytes and points used in ranges are 0-indexed.
}
\examples{
x <- range(5, point(1, 3), 7, point(1, 5))
x

range_start_byte(x)
range_end_byte(x)

range_start_point(x)
range_end_point(x)

is_range(x)
}
\seealso{
\code{\link[=node_range]{node_range()}}
}
