% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parser-parse}
\alias{parser-parse}
\alias{parser_parse}
\alias{parser_reparse}
\title{Parse or reparse text}
\usage{
parser_parse(x, text, ..., encoding = "UTF-8")

parser_reparse(
  x,
  text,
  tree,
  start_byte,
  start_point,
  old_end_byte,
  old_end_point,
  new_end_byte,
  new_end_point,
  ...,
  encoding = "UTF-8"
)
}
\arguments{
\item{x}{\verb{[tree_sitter_parser]}

A parser.}

\item{text}{\verb{[string]}

The text to parse.}

\item{...}{These dots are for future extensions and must be empty.}

\item{encoding}{\verb{[string]}

The expected encoding of the \code{text}. Either \code{"UTF-8"} or \code{"UTF-16"}.}

\item{tree}{\verb{[tree_sitter_tree]}

The original tree returned by \code{parser_parse()}. Components of the tree
will be reused to perform the incremental reparse.}

\item{start_byte, start_point}{\verb{[double(1) / tree_sitter_point]}

The starting byte and starting point of the edit location.}

\item{old_end_byte, old_end_point}{\verb{[double(1) / tree_sitter_point]}

The old ending byte and old ending point of the edit location.}

\item{new_end_byte, new_end_point}{\verb{[double(1) / tree_sitter_point]}

The new ending byte and new ending point of the edit location.}
}
\value{
A new \code{tree}.
}
\description{
\itemize{
\item \code{parser_parse()} performs an initial parse of \code{text}, a string typically
containing contents of a file. It returns a \code{tree} for further
manipulations.
\item \code{parser_reparse()} performs a fast incremental reparse. \code{text} is typically
a slightly modified version of the original \code{text} with a new "edit"
applied. The position of the edit is described by the byte and point
arguments to this function. The \code{tree} argument corresponds to the original
\code{tree} returned by \code{parser_parse()}.
}

All bytes and points should be 0-indexed.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "1 + foo"
tree <- parser_parse(parser, text)
tree

text <- "1 + bar(foo)"
parser_reparse(
  parser,
  text,
  tree,
  start_byte = 4,
  start_point = point(0, 4),
  old_end_byte = 7,
  old_end_point = point(0, 7),
  new_end_byte = 12,
  new_end_point = point(0, 12)
)
\dontshow{\}) # examplesIf}
}
