% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree-accessors}
\alias{tree-accessors}
\alias{tree_included_ranges}
\alias{tree_text}
\alias{tree_language}
\title{Tree accessors}
\usage{
tree_included_ranges(x)

tree_text(x)

tree_language(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_tree]}

A tree.}
}
\value{
\itemize{
\item \code{tree_text()} returns a string.
\item \code{tree_language()} returns a \code{tree_sitter_language}.
\item \code{tree_included_ranges()} returns a list of \code{\link[=range]{range()}} objects.
}
}
\description{
\itemize{
\item \code{tree_text()} retrieves the tree's \code{text} that it was parsed with.
\item \code{tree_language()} retrieves the tree's \code{language} that it was parsed with.
\item \code{tree_included_ranges()} retrieves the tree's \code{included_ranges} that were
provided to \code{\link[=parser_set_included_ranges]{parser_set_included_ranges()}}. Note that if no ranges were
provided originally, then this still returns a default that always covers
the entire document.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "1 + foo"
tree <- parser_parse(parser, text)

tree_text(tree)
tree_language(tree)
tree_included_ranges(tree)
\dontshow{\}) # examplesIf}
}
