% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTreeDiff.R
\name{plotTreeDiff}
\alias{plotTreeDiff}
\title{Plot tree differences}
\usage{
plotTreeDiff(tr1, tr2, tipDiff = NULL, vec1 = NULL, vec2 = NULL,
  baseCol = "grey", col1 = "peachpuff", col2 = "red2", ...)
}
\arguments{
\item{tr1}{an object of the class \code{phylo}: the first tree to plot.}

\item{tr2}{an object of the class \code{phylo}: the second tree to plot.}

\item{tipDiff}{an optional input, the result of \code{\link{tipDiff}}. Supplying this will save time if calling \code{plotTreeDiff} repeatedly, for example with different aesthetics.}

\item{vec1}{an optional input, the result of \code{treeVec(tr1, lambda=0)}. This argument is ignored if \code{tipDiff} is supplied; otherwise supplying this will save time if calling \code{plotTreeDiff} repeatedly, for example with different aesthetics.}

\item{vec2}{an optional input, the result of \code{treeVec(tr2, lambda=0)}. This argument is ignored if \code{tipDiff} is supplied; otherwise supplying this will save time if calling \code{plotTreeDiff} repeatedly, for example with different aesthetics.}

\item{baseCol}{the colour used for tips with identical ancestry in the two trees. Defaults to "grey".}

\item{col1}{the first colour used to define the colour spectrum for tips with differences. This colour will be used for tips with minor differences. Defaults to "peachpuff".}

\item{col2}{the second colour used to define the colour spectrum for tips with differences. This colour will be used for tips with major differences. Defaults to "red2".}

\item{...}{further arguments passed to \code{\link{plot.phylo}}}
}
\value{
A plot of the two trees side by side. Tips are coloured in the following way:
\itemize{
\item if each ancestor of a tip in tree 1 occurs in tree 2 with the same partition of tip descendants, then the tip is coloured grey (or supplied "baseCol")
\item if not, the tip gets coloured pale orange to red on a scale according to how many differences there are amongst its most recent common ancestors with other tips. The colour spectrum can be changed according to preference.
}
}
\description{
Highlight the topologicial differences between two trees, plotted side by side. 
This function is useful for comparing representative "median" trees - see \code{\link{medTree}}.
It relies on the function \code{\link{tipDiff}}.
}
\examples{
## simple example on trees with five tips:
tr1 <- read.tree(text="((A:1,B:1):1,((C:1,D:1):1,E:1):1):1;")
tr2 <- read.tree(text="((A:1,B:1):1,(C:1,(D:1,E:1):1):1):1;")
plotTreeDiff(tr1,tr2)

## example on larger woodmice trees
data(woodmiceTrees)
# find the tip differences in advance, to avoid recalculating with each plot
wmTipDiff <- tipDiff(woodmiceTrees[[1]],woodmiceTrees[[2]])
plotTreeDiff(woodmiceTrees[[1]],woodmiceTrees[[2]], tipDiff=wmTipDiff)
## change aesthetics:
plotTreeDiff(woodmiceTrees[[1]],woodmiceTrees[[2]], tipDiff=wmTipDiff,
   baseCol="grey2", col1="cyan", col2="navy", 
   edge.width=2, type="radial", cex=0.5, font=2)

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\seealso{
\code{\link{medTree}}, \code{\link{tipDiff}}
}

