% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{treeDist}
\alias{treeDist}
\title{Metric function}
\usage{
treeDist(tree.a, tree.b, lambda = 0, return.lambda.function = FALSE,
  emphasise.tips = NULL, emphasise.weight = 2)
}
\arguments{
\item{tree.a}{an object of the class \code{phylo}}

\item{tree.b}{an object of the class \code{phylo} (with the same tip labels as tree.a)}

\item{lambda}{a number in [0,1] which specifies the extent to which topology (default, with lambda=0)  or branch lengths (lambda=1) are emphasised. This argument is ignored if \code{type="function"}.}

\item{return.lambda.function}{If true, a function that can be invoked with different lambda values is returned.
This function returns the vector of metric values for the given lambda.}

\item{emphasise.tips}{an optional list of tips whose entries in the tree vectors should be emphasised. Defaults to \code{NULL}.}

\item{emphasise.weight}{applicable only if a list is supplied to \code{emphasise.tips}, this value (default 2) is the number by which vector entries corresponding to those tips are emphasised.}
}
\value{
The vector with the metric values or a function that produces the vector given a value of lambda.
}
\description{
Comparison of two trees using the Kendall Colijn metric
}
\examples{

## generate random trees
tree.a <- rtree(6)
tree.b <- rtree(6)
treeDist(tree.a,tree.b) # lambda=0
treeDist(tree.a,tree.b,1)  # lambda=1
dist.func <- treeDist(tree.a,tree.b,return.lambda.function=TRUE) # distance as a function of lambda
dist.func(0) # evaluate at lambda=0. Equivalent to treeDist(tree.a,tree.b).
## We can see how the distance changes when moving from focusing on topology to length:
plot(sapply(seq(0,1,length.out=100), function(x) dist.func(x)), type="l",ylab="",xlab="")

## The distance may also change if we emphasise the position of certain tips:
plot(sapply(tree.a$tip.label, function(x) treeDist(tree.a,tree.b,emphasise.tips=x)),
     xlab="Tip number",ylab="Distance when  vector entries corresponding to tip are doubled")


}
\author{
Jacob Almagro-Garcia \email{nativecoder@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

