% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilson_hilferty.R
\name{wilson_hilferty}
\alias{wilson_hilferty}
\title{Modified Wilson-Hilferty approximation}
\usage{
wilson_hilferty(x, df)
}
\arguments{
\item{x}{Numeric value of the observed chi-square statistic.}

\item{df}{Integer specifying the degrees of freedom associated with \code{x}.}
}
\value{
An approximate chi-square statistic with one degree of freedom.
}
\description{
Implements the modified Wilson-Hilferty (1931) approximation used by GUIDE to 
convert a chi-square random variable to an approximate chi-square random
variable with one degree of freedom.
}
\examples{
wilson_hilferty(2056, df = 4)
wilson_hilferty(1831, df = 20)

set.seed(1144)  # for reproducibility
x <- rchisq(1000, df = 10)
w <- sapply(x, FUN = function(x) wilson_hilferty(x, df = 10))
px <- pchisq(x, df = 10)
pw <- pchisq(round(w), df = 1)
plot(px, pw)
abline(0, 1, lty = 2, col = 2)
cor(px, pw)
}
