% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_setup.R
\name{guide_setup}
\alias{guide_setup}
\title{Generate GUIDE input files}
\usage{
guide_setup(
  data,
  path,
  dv = NULL,
  var.roles = NULL,
  na = "NA",
  file.name = NULL,
  data.loc = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame containing the training data.}

\item{path}{Character string specifying the full path to where the GUIDE 
input files will be written to. If the given path does not exist, it will be
created automatically using \code{dir.create()}.}

\item{dv}{Character string specifying which column represents the target/
dependent variable.}

\item{var.roles}{A named character vector specifying the role of each column.}

\item{na}{Character string specifying the missing value indicator.}

\item{file.name}{Character string giving the file name (or prefix) to use for
the generated input files. If \code{NULL}, the default, it will be parsed 
from the \code{data} argument.}

\item{data.loc}{Character string specifying the the full path to the data
input file, which is used for the first line of the generated description 
file. If \code{NULL}, the default, it will be determined automatically by 
\code{path} and \code{file.name}. This is useful if the data input file does 
not reside in the same directory as the GUIDE executable.}

\item{verbose}{Logical indicating whether or not to print progress 
information.}
}
\value{
No return value, only called for side effects; in this case, two
text file are created for consumption by the GUIDE terminal application
}
\description{
Just a simple helper function I found useful while using the GUIDE terminal 
application (http://pages.stat.wisc.edu/~loh/guide.html). It creates two 
input text files required by GUIDE: a data file and description file.
}
\note{
This function assumes that the GUIDE executable is located in the same 
directory specified by the `path` argument. For details, see the official 
software manual for GUIDE: 
\url{http://pages.stat.wisc.edu/~loh/treeprogs/guide/guideman.pdf}. This 
function has only been tested on GUIDE v38.0.
}
\examples{
\dontrun{
# New York air quality measurements
aq <- airquality
aq <- aq[!is.na(aq$Ozone), ]  # remove rows with missing response values

# Default variable roles
guide_setup(aq, path = "some/path/aq", dv = "Ozone")

# User specified variable roles
var.roles <- c("Ozone" = "d", "Solar.R" = "n", "Wind" = "n", "Temp" = "c",
               "Month" = "p", "Day" = "p")
guide_setup(aq, path = "some/path/aq", var.roles = var.roles)
}
}
