% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treefit.R
\name{plot.treefit}
\alias{plot.treefit}
\title{Plot estimated results}
\usage{
\method{plot}{treefit}(x, ...)
}
\arguments{
\item{x}{The estimated result by \code{treefit()} to be visualized.}

\item{...}{The more estimated results to be visualized together or
other graphical parameters.}
}
\value{
A plot object as a \code{ggplot} object. It plots the given one
or more estimated results to get insights from one or more
\code{treefit()} results.
}
\description{
Plot estimate results to get insight.
}
\examples{
# Generate a tree data.
tree <- treefit::generate_2d_n_arms_star_data(200, 3, 0.1)
# Estimate the goodness-of-fit between tree models and the tree data.
fit <- treefit::treefit(list(expression=tree), "tree")
# Visualize the estimated result.
plot(fit)

# You can mix multiple estimated results by adding "name" column.
tree2 <- treefit::generate_2d_n_arms_star_data(200, 3, 0.9)
fit2 <- treefit::treefit(list(expression=tree2), "tree2")
plot(fit, fit2)

}
