% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/deprecated_sim_functions.R
\name{sim_stBD_t}
\alias{sim_stBD_t}
\alias{sim_sptree_bdp_time}
\title{Simulates species tree using constant rate birth-death process to a time}
\usage{
sim_stBD_t(sbr, sdr, numbsim, t)

sim_sptree_bdp_time(sbr, sdr, numbsim, t)
}
\arguments{
\item{sbr}{species birth rate (i.e. speciation rate)}

\item{sdr}{species death rate (i.e. extinction rate)}

\item{numbsim}{number of species trees to simulate}

\item{t}{time to simulate to}
}
\value{
List of objects of the tree class (as implemented in APE)
}
\description{
Forward simulates a tree until a provided time is reached.
}
\examples{
mu <- 0.5 # death rate
lambda <- 2.0 # birth rate
numb_replicates <- 10
time <- 1

tree_list <- sim_stBD_t(sbr = lambda,
                sdr = mu,
                numbsim = numb_replicates,
                t = time)
}
\references{
K. Hartmann, D. Wong, T. Stadler. Sampling trees from evolutionary models.
    Syst. Biol., 59(4): 465-476, 2010.

T. Stadler. Simulating trees on a fixed number of extant species.
    Syst. Biol., 60: 676-684, 2011.
}
