% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cophy.R
\name{plot.cophy}
\alias{plot.cophy}
\alias{plot.multiCophy}
\title{Plot host and symbiont pair with current associations}
\usage{
\method{plot}{cophy}(
  x,
  use_edge_length = TRUE,
  type = "phylogram",
  col = par("fg"),
  lwd = par("lwd"),
  lty = par("lty"),
  show_tip_label = TRUE,
  gap = 1,
  font = 3,
  fsize = 1,
  show_div_bar = FALSE,
  ...
)

\method{plot}{multiCophy}(x, ...)
}
\arguments{
\item{x}{object of class multiCophy}

\item{use_edge_length}{Boolean to draw trees with edge length or not}

\item{type}{string "phylogram" or "cladogram"}

\item{col}{What color to draw links between trees}

\item{lwd}{Width of links between trees}

\item{lty}{Type of line to draw between trees}

\item{show_tip_label}{Boolean for showing labels}

\item{gap}{Size of the gap between the tips and tip names}

\item{font}{What font to use (bold, italic (default), etc.)}

\item{fsize}{What size font as a character expansion factor (same as cex)}

\item{show_div_bar}{Shows a bar under both trees with ticks where the divergences are (default: F)}

\item{...}{other plotting parameters}
}
\value{
a plot of the host and symbiont tree with extant interactions
}
\description{
This function plots a host and symbiont tree given the object returned by
`sim_cophyBD`.
}
\details{
This function is mostly an altered version of the cophyloplot function
written by Damien de Vienne Copyright 2008 - 2010 under GPL.
}
\section{Functions}{
\itemize{
\item \code{plot.multiCophy}: Plots multiple cophy plots
}}

\examples{
host_mu <- 1.0 # death rate
host_lambda <- 2.0 # birth rate
numb_replicates <- 10
time <- 1.0
symb_mu <- 0.2
symb_lambda <- 0.4
host_shift_rate <- 0.0
cosp_rate <- 2.0

cophylo_pair <- sim_cophyBD(hbr = host_lambda,
                           hdr = host_mu,
                           cosp_rate = cosp_rate,
                           host_exp_rate = host_shift_rate,
                           sdr = symb_mu,
                           sbr = symb_lambda,
                           numbsim = numb_replicates,

                           time_to_sim = time)
plot.cophy(cophylo_pair[[1]])
}
\author{
Wade Dismukes and Damien de Vienne
}
