% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCharacterType.R
\name{hasNames}
\alias{hasNames}
\title{Row and column name check}
\usage{
hasNames(dat, nameType = "row")
}
\arguments{
\item{dat}{A vector of data}

\item{nameType, }{either:
\describe{
\item{"row"}{Rows (default)}
\item{"col"}{Columns}
\item{"rowcol"}{Both rows and columns}
}}
}
\value{
\code{TRUE} or \code{FALSE} indicating if the object has names (\code{columns},
\code{rows}, or
\code{both})
}
\description{
This function checks whether a given \code{data.frame} or \code{matrix} has
column names (\code{colnames}), row.names (\code{row.names}), or both.
}
\examples{
data(anolis)
hasNames(anolis$dat, "row")
}
