% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rogersI.R
\name{rogersI}
\alias{rogersI}
\title{Calculation of the Rogers J index for rooted binary trees}
\usage{
rogersI(tree)
}
\arguments{
\item{tree}{A rooted binary tree in phylo format.}
}
\value{
\code{rogersI} returns the Rogers J index of the given tree.
}
\description{
This function calculates the Rogers J index \eqn{J(T)} for a given rooted
binary tree \eqn{T}. It is defined as the number of inner vertices whose balance
value is unequal to zero, more precisely
\deqn{J(T)=\sum_{u \in V_{in}(T)} (1-I(n_{u_a}=n_{u_b}))}{J(T)=\sum (1-I(n_{u_a}=n_{u_b})) over all u in V_in(T)}
in which \eqn{V_{in}(T)}{V_in(T)} denotes the set of all inner vertices
of \eqn{T}, and in which \eqn{n_{u_a}}{n_ua}
and \eqn{n_{u_b}}{n_ub} denote the number of leaves in the two pending subtrees that are
rooted at the direct descendants of \eqn{u}. \cr
Special cases: For \eqn{n=1}, the function returns \eqn{J(T)=0} and a warning.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
rogersI(tree)

}
\references{
J. S. Rogers. Central Moments and Probability Distributions of Three Measures of Phylogenetic Tree Imbalance. Systematic Biology, 45(1):99-110, 1996. doi: 10.1093/sysbio/45.1.99.
}
\author{
Sophie Kersting
}
