% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxDelW.R
\name{maxDelW}
\alias{maxDelW}
\title{Calculation of the maximal difference in widths for a rooted tree}
\usage{
maxDelW(tree)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}
}
\value{
\code{maxDelW} returns the maximal difference in widths of a tree.
}
\description{
This function calculates the maximal difference in widths \eqn{maxDelW(T)} for a
given rooted tree \eqn{T}. The tree must not necessarily be binary.
\eqn{maxDelW(T)} is defined as \deqn{maxDelW(T)=\max_{i=0,...,h(T)-1} w(i+1)-w(i)}{maxDelW(T)=max_{i=0,...,h(T)-1} w(i+1)-w(i)}
in which \eqn{h(T)} denotes the height of the tree \eqn{T} and \eqn{w(i)} denotes
the number of vertices in \eqn{T} that have depth \eqn{i}. The maximal difference
in widths is a balance index.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
maxDelW(tree)
tree <- ape::read.tree(text="((,),((((,),),),(,)));")
maxDelW(tree)

}
\references{
C. Colijn and J. Gardy. Phylogenetic tree shapes resolve disease transmission patterns. Evolution, Medicine, and Public Health, 2014(1):96-108, 2014. ISSN 2050-6201. doi: 10.1093/emph/eou018.
}
\author{
Sophie Kersting, Luise Kuehn
}
