% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aread8.R
\name{taudem_aread8}
\alias{taudem_aread8}
\title{D8 Contributing Area}
\usage{
taudem_aread8(
  input_d8flowdir_grid,
  output_contributing_area_grid = NULL,
  check_edge_contamination = TRUE,
  n_processes = getOption("traudem.n_processes", 1),
  wg_file = NULL,
  outlet_file = NULL,
  outlet_layer_name = NULL,
  outlet_layer_number = NULL,
  quiet = getOption("traudem.quiet", FALSE)
)
}
\arguments{
\item{input_d8flowdir_grid}{Input flow directions grid.}

\item{output_contributing_area_grid}{Output contributing area grid.}

\item{check_edge_contamination}{Whether to check for edge contamination.}

\item{n_processes}{Number of processes for \code{mpiexec}. If \code{NULL} TauDEM is called without mpiexec.}

\item{wg_file}{Input weight grid (optional).}

\item{outlet_file}{Input outlets file (OGR readable dataset, optional).}

\item{outlet_layer_name}{OGR layer name if outlets are not the first layer in \code{outlet_file} (optional).
Layer name and layer number should not both be specified.}

\item{outlet_layer_number}{OGR layer number if outlets are not the first layer in \code{outlet_file} (optional).
Layer name and layer number should not both be specified.}

\item{quiet}{If \code{FALSE} output from TauDEM CLI is suppressed.}
}
\value{
Path to output file (invisibly).
}
\description{
D8 Contributing Area
}
\details{
See \url{https://hydrology.usu.edu/taudem/taudem5/help53/D8ContributingArea.html}
}
\examples{
\dontshow{if (interactive() && traudem::can_register_taudem()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
test_dir <- withr::local_tempdir()
dir.create(test_dir)
 file.copy(
   system.file("test-data", "DEM.tif", package = "traudem"),
   file.path(test_dir, "DEM.tif")
 )

filled_pit <- taudem_pitremove(file.path(test_dir, "DEM.tif"))
outputs <- taudem_d8flowdir(filled_pit)
outputs
contributing_area_grid <- taudem_aread8(outputs$output_d8flowdir_grid)
contributing_area_grid
\dontshow{\}) # examplesIf}
}
