## ----setup,include=FALSE------------------------------------------------------
knitr::opts_chunk$set(eval=FALSE,echo=TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  data(dataVerlaat,package="GRridge")
#  
#  y <- as.numeric(as.factor(respVerlaat))-1
#  X <- t(datcenVerlaat)
#  prior <- sign(diffmeanFarkas)*(-log10(pvalFarkas))

## -----------------------------------------------------------------------------
#  set.seed(1)
#  foldid.ext <- sample(rep(1:10,length.out=length(y)))
#  foldid.int <- sample(rep(1:10,length.out=length(y)))
#  
#  y_hat <- data.frame(truth=y)
#  
#  for(i in 1:10){
#  
#    holdout <- foldid.ext==i
#    foldid <- foldid.int[!holdout]
#  
#    # training data
#    y0 <- y[!holdout]
#    X0 <- X[!holdout,]
#    # testing data
#    X1 <- X[holdout,]
#  
#    glmnet <- glmnet::cv.glmnet(y=y0,x=X0,family="binomial",foldid=foldid,alpha=1)
#    y_hat$glmnet[holdout] <- predict(glmnet,newx=X1,type="response",s="lambda.min")
#  
#    rf <- randomForest::randomForest(x=X0,y=as.factor(y0),norm.votes=TRUE)
#    y_hat$rf[holdout] <- predict(rf,newdata=X1,type="prob")[,2]
#  
#    svm <- e1071::svm(x=X0,y=as.factor(y0),kernel="linear",probability=TRUE)
#    y_hat$svm[holdout] <- attributes(predict(svm,newdata=X1,probability=TRUE))$probabilities[,2]
#  
#    transreg <- transreg::transreg(y=y0,X=X0,prior=prior,family="binomial",foldid=foldid,alpha=1)
#    y_hat$transreg[holdout] <- predict(transreg,newx=X1)
#  }
#  
#  apply(y_hat,2,function(x) pROC::auc(pROC::roc(response=y,predictor=x,direction="<")))
#  
#  apply(y_hat,2,function(x) starnet:::.loss(y=y,x=x,family="binomial",type.measure="auc",foldid=foldid.ext))

