% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shielding.R
\name{shielding}
\alias{shielding}
\title{Compute Optimal Transport (Cost/Plan) Using the Multiscale Shielding Method}
\usage{
shielding(a, b, nscales = 2, startscale = 1, flood = 0,
  measureScale = 1e-06, verbose = FALSE, basisKeep = 1,
  basisRefine = 1)
}
\arguments{
\item{a, b}{arrays with \eqn{d} coordinates representing source and target measure, respectively.
The entries must be all positive.}

\item{nscales}{the number of scales generated in the multiscale algorithm.}

\item{startscale}{the first scale on which the problem is solved.}

\item{flood}{a real number. If positive, take the maximum of entry and \code{flood} for each
entry of \code{a} and \code{b}.}

\item{measureScale}{the required precision for the entries. Computations are performed on
\code{round(a/measureScale)} and the same for \code{b} using integer arithmetics.}

\item{verbose}{logical. Toggles output to the console about the progress of the algorithm.}

\item{basisKeep, basisRefine}{internal use only.}
}
\value{
A list of components
\item{err}{error code. 0 if everything is ok.} 
\item{a_used,b_used}{the vectorized arrays that were actually used by the algorithm. \code{a}, \code{b} after
                applying \code{flood} and \code{measureScale}.}  
\item{coupling}{a vectorized coupling describing the optimal transport from a_used to b_used}
\item{basis}{a matrix with two columns describing the basis obtained for the optimal transport}
\item{u,v}{vectors of optimal values in the dual problem}
}
\description{
Runs the multiscale version of the Shielding Method (a.k.a. Short Cut Method) for computing the optimal transport
(cost/plan) on a rectangular grid in \eqn{d} dimensions for the squared Euclidean distance as cost function.
}
\details{
If \code{a} and \code{b} do not have the same sum, they are normalized to sum 1 \emph{before}
\code{flood} and \code{measureScale} transformations are applied.
}
\section{Use of CPLEX}{

For larger problems (thousands of grid points) there are considerable speed improvements when \code{shielding}
can use the CPLEX numerical solver for the underlying constrained optimization problems.
If a local installation of CPLEX is available, the transport package can be linked against it during installation.
See the file src/Makevars in the source package for instructions.
}

\examples{
\dontrun{
shielding(random64a$mass,random64b$mass,nscales=6,measureScale=1) }

}
\references{
B. Schmitzer (2016). A sparse multiscale algorithm for dense optimal transport. J. Math. Imaging Vision 56(2), 238--259. \href{https://arxiv.org/abs/1510.05466}{https://arxiv.org/abs/1510.05466}
}
\seealso{
\code{\link{transport}}, which calls this function if appropriate.
}
\author{
Bernhard Schmitzer \email{schmitzer@uni-muenster.de} and\cr
        Dominic Schuhmacher \email{dschuhm1@uni-goettingen.de}\cr
        (based on C++ code by Bernhard Schmitzer)
}
