package jpsgcs.alun.markov;

import jpsgcs.alun.util.MarkedObject;
import java.util.Set;

/** 
 A Function is a mapping from the states of a set of variables to a double.
*/
abstract public class Function implements MarkedObject
{
/**
 Returns the current value of the Function.
*/
	abstract public double getValue();

/**
 Returns an array of the variables that are arguments to the function.
*/
	abstract public Variable[] getVariables();

	public Parameter[] getParameters()
	{
		return noparameters;
	}

	public double logValue()
	{
		return Math.log(getValue());
	}

	public final boolean isMarked()
	{
		return m;
	}

	public final void mark()
	{
		m = true;
	}

	public final void unmark()
	{
		m = false;
	}

	private boolean m = false;
	private final static Parameter[] noparameters = new Parameter[0];
}
