package jpsgcs.alun.infect;

import jpsgcs.alun.hashing.RandomSet;

public class InfSimulator
{
	public static final int ADMIT = 0;
	public static final int INFEC = 1;
	public static final int DISCH = 2;
	public static final int TEST = 3;

	public InfSimulator(double ilambda, double iimportation, double idetection, double iend, int icapacity, double imeanstay, double ibalance, double itestperpady, boolean iwithinf)
	{
		now = 0;
		end = iend;
		delta = 1/imeanstay;
		alpha = delta * icapacity * ibalance;
		lambda = ilambda;
		importation = iimportation;
		detection = idetection;
		capacity = icapacity;
		withinf = iwithinf;
		testperpady = itestperpady;

		all = new RandomSet<Person>();
		sus = new RandomSet<Person>();
	}

	public boolean hasNext()
	{
		return now < end;
	}
	
	public Event nextEvent()
	{
		while (now < end)
		{
			if (store != null)
			{
				Event res = store;
				store = null;
				return res;
			}

			Person p = null;

			double next = exp(alpha);
			int type = ADMIT;
	
			double t = exp(delta * all.size());
			if (t < next)
			{
				next = t;
				type = DISCH;
			}
	
			t = exp(lambda * sus.size() * (all.size() - sus.size()));
			if (t < next)
			{
				next = t;
				type = INFEC;
			}
	
			t = exp(testperpady * all.size());
			if (t < next)
			{
				next = t;
				type = TEST;
			}
	
			now += next;

			switch(type)
			{
			case ADMIT:
				if (all.size() >= capacity)
					break;
	
				p = new Person();
				p.admit = now;
				all.add(p);
				sus.add(p);
					
				Event res = new ContinuousEvent(now,p.index,Event.ADMISSION);

				if (Math.random() < importation)
				{
					p.infected = true;
					p.inftime = p.admit;
					sus.remove(p);
					if (withinf)
						store = new ContinuousEvent(now,p.index,Event.INFECTION);
				}

				return res;

			case DISCH:
				p = all.next();
				all.remove(p);
				sus.remove(p);
				p.disch = now;
				return new ContinuousEvent(now,p.index,Event.DISCHARGE);

			case TEST:
				p = all.next();
				int testres = (p.infected && Math.random() < detection ? Event.POSTEST : Event.NEGTEST);
				return new ContinuousEvent(now,p.index,testres);

			case INFEC:
				p = sus.next();
				sus.remove(p);
				p.infected = true;
				p.inftime = now;
				if (withinf)
					return new ContinuousEvent(now,p.index,Event.INFECTION);
				break;
			}
		}

		return null;
	}

// Private data and methods.

	private Event store = null;
	private double end = 0;
	private double now = 0;
	private double delta = 0;
	private double alpha= 0;
	private double lambda = 0;
	private double testperpady = 0;
	private double importation = 0;
	private double detection = 0;
	private int capacity =0;
	private boolean withinf = false;

	private RandomSet<Person> all = null;
	private RandomSet<Person> sus = null;
	
	private static double exp(double rate)
	{
		return -Math.log(Math.random()) / rate;
	}
}
