% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uuid.R
\name{uuid}
\alias{uuid}
\alias{uuid_raw}
\alias{uuid_is}
\title{Universally Unique Identifiers}
\usage{
uuid()

uuid_raw()

uuid_is(x)
}
\arguments{
\item{x}{An \R object.}
}
\value{
\code{\link[=uuid]{uuid()}} returns a character of length 1 containing exactly 36
characters: 32 hexadecimal characters and 4 hyphens (used as separators).

\code{\link[=uuid_raw]{uuid_raw()}} returns a raw vector of length 16.

\code{\link[=uuid_is]{uuid_is()}} returns a logical vector having the same length as \code{x}. It
checks whether its elements are valid version 4 (variant 1) UUIDs or
not. It returns \code{FALSE} for any other kind of UUID.
}
\description{
Generate a random UUID (\emph{Universally Unique Identifier}) that complies to
what \href{https://www.rfc-editor.org/rfc/rfc4122}{RFC4122} prescribes. Such a
value is also known as a \emph{version 4} UUID.
}
\details{
\code{\link[=uuid]{uuid()}} calls \code{\link[=uuid_raw]{uuid_raw()}} and formats its output accordingly.

Pseudo-random bytes are generated with \code{\link[=sample]{sample()}} whenever \code{\link[=uuid_raw]{uuid_raw()}}
is called. This is most likely done before runtime when
\code{\link{Translator}} objects are created. \code{\link[=uuid_raw]{uuid_raw()}} samples values
in the \verb{[0, 255]} range with replacement and converts them to \link[=raw]{raw}
values. The user must ensure that the underlying seed is appropriate when
generating UUIDs. See \code{\link[=set.seed]{set.seed()}} for more information.
}
\note{
UUIDs are designed to be globally unique (collisions are extremely unlikely)
and are sometimes called GUIDs (\emph{Globally Unique Identifiers}). There are
several UUID versions with slightly different purposes.

Package \code{\link{transltr}} uses random identifiers (version 4/variant 1,
also known as DCE 1.1, ISO/IEC 11578:1996).
}
\examples{
uuid()
uuid_raw()
uuid_is(uuid())      ## TRUE
uuid_is(uuid_raw())  ## FALSE, uuid_raw() does not return a string.

}
\seealso{
\href{https://www.rfc-editor.org/rfc/rfc4122}{RFC4122},
\href{https://www.uuidtools.com/uuid-versions-explained}{UUIDs explained}
}
\keyword{internal}
