% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{dicp_controls}
\alias{dicp_controls}
\title{TRAMICP Controls}
\usage{
dicp_controls(
  type = "residual",
  test = "gcm.test",
  baseline_fixed = TRUE,
  alpha = 0.05,
  method = "gamma",
  kernel = c("gaussian", "discrete"),
  B = 499,
  vcov = "vcov",
  teststat = "maximum",
  distribution = "asymptotic",
  xtrafo = coin::trafo,
  ytrafo = coin::trafo,
  residuals = "residuals",
  crossfit = getOption("crossfit", default = FALSE),
  stop_if_empty_set_invariant = getOption("stop_if_empty_set_invariant", default = FALSE),
  wald_test_interactions = getOption("wald_test_interactions", default = TRUE)
)
}
\arguments{
\item{type}{Character, type of invariance (\code{"residual"} or \code{"wald"});
see \code{Details}.}

\item{test}{Character, specifies the invariance test to be used when
\code{type = "residual"}. The default is \code{"gcm.test"}. Other
implemented tests are \code{"HSIC"}, \code{"t.test"}, \code{"var.test"},
and \code{"combined"}. Alternatively, a custom function for testing
invariance of the form \code{\(r, e, controls) {...}} can be supplied,
which outputs a list with entry \code{"p.value"}.}

\item{baseline_fixed}{Logical; whether or not the baseline transformation
is allowed to vary with the environments. Only takes effect when
\code{type} is \code{"wald"}.}

\item{alpha}{Level of invariance test, default \code{0.05}.}

\item{method}{Only applies if \code{test = "HSIC"}. See
\code{\link[dHSIC]{dhsic.test}}.}

\item{kernel}{Only applies if \code{test = "HSIC"}. See \code{\link[dHSIC]{dhsic.test}}.}

\item{B}{For \code{test = "HSIC"}, see \code{\link[dHSIC]{dhsic.test}}.}

\item{vcov}{(Name of) function for computing the variance-covariance matrix of a model.}

\item{teststat}{Only applies if \code{test = "independence"}.
See \code{\link[coin]{independence_test}}.}

\item{distribution}{Only applies if \code{test = "independence"}.
See \code{\link[coin]{independence_test}}.}

\item{xtrafo}{Only applies if \code{test = "independence"}.
See \code{\link[coin]{independence_test}}.}

\item{ytrafo}{Only applies if \code{test = "independence"}.
See \code{\link[coin]{independence_test}}.}

\item{residuals}{Character or function; (Name of) function for computing
model residuals. The default is \code{stats::residuals} with methods
dispatch.}

\item{crossfit}{Logical; toggle for cross fitting when \code{type = "residual"}.}

\item{stop_if_empty_set_invariant}{Logical; \code{dicp} halts if the empty
set is not rejected (the resulting intersection will always be empty).
Default is \code{FALSE} and can be over-written by setting
\code{options(stop_if_empty_set_invariant = TRUE)}.}

\item{wald_test_interactions}{Logical; whether to test for interactions between
residuals and environments when using \code{type = "wald"}
(\code{wald_test_interactions = TRUE}, the default) or main effects only
(\code{wald_test_interactions = FALSE}).}
}
\value{
List of dicp controls containing the evaluated arguments from above.
}
\description{
TRAMICP Controls
}
