% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvregME.R
\name{SurvregME}
\alias{SurvregME}
\title{Mixed-effects version of \code{\link[tram]{Survreg}}}
\usage{
SurvregME(
  formula,
  data,
  subset,
  weights,
  offset,
  na.action = na.omit,
  dist = c("weibull", "logistic", "gaussian", "exponential", "rayleigh", "loggaussian",
    "lognormal", "loglogistic"),
  scale = 0,
  silent = TRUE,
  resid = FALSE,
  do_update = FALSE,
  estinit = TRUE,
  initpar = NULL,
  fixed = NULL,
  nofit = FALSE,
  control = optim_control(),
  ...
)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description 
          of the model structure to be
          fitted.  The details of model specification are given under
          \code{\link[tram]{tram}} and in the package vignette.
  }

\item{data}{an optional data frame, list or environment (or object
          coercible by \code{as.data.frame} to a data frame) containing the
          variables in the model.  If not found in \code{data}, the
          variables are taken from \code{environment(formula)}.
  }

\item{subset}{an optional vector specifying a subset of observations to be
          used in the fitting process.
  }

\item{weights}{an optional vector of weights to be used in the fitting
          process.  Should be \code{NULL} or a numeric vector. If present,
          the weighted log-likelihood is maximised.
  }

\item{offset}{this can be used to specify an _a priori_ known component to
          be included in the linear predictor during fitting.  This
          should be \code{NULL} or a numeric vector of length equal to the
          number of cases.
  }

\item{na.action}{a function which indicates what should happen when the data
          contain \code{NA}s.  The default is set by the \code{na.action} setting
          of \code{options}, and is \code{na.fail} if that is unset.
  }

\item{dist}{character defining the conditional distribution of the
    (not necessarily positive) response, current choices include 
    Weibull, logistic, normal, exponential, Rayleigh, log-normal (same as
    log-gaussian), or log-logistic.
  }

\item{scale}{a fixed value for the scale parameter(s).
  }

\item{silent}{logical, make TMB functionality silent}

\item{resid}{logical, Should the score residuals also be calculated?}

\item{do_update}{Logical. If \code{TRUE}, the model is set up so that the weights and the
offsets are updateable. This comes with some performance cost.}

\item{estinit}{logical, estimate a vector of initial values for the fixed effects parameters
from a (fixed effects only) mlt model}

\item{initpar}{named list of initial parameter values, if \code{NULL}, it is ignored}

\item{fixed}{a named vector of fixed regression coefficients; the names
               need to correspond to column names of the design matrix}

\item{nofit}{logical, if TRUE, creates the model object, but does not run the optimization}

\item{control}{list with controls for optimization}

\item{...}{additional arguments to \code{\link[tram]{tram}}.}
}
\value{
A \code{SurvregME} object.
}
\description{
Mixed-effects version of \code{\link[tram]{Survreg}}
}
